#include <Primitives/DAQBuilderByte.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  Cloneable *                Byte::clone() const
  {
    return (Cloneable*)new Byte(*this);
  }
  Byte::Byte()
    :Number((DByte)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Byte::Byte(const DByte& value)
    :Number((DByte)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Byte::Byte( const Byte & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Byte::Byte( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Byte::Byte( const DString  & value )
    :Number((DByte)value[0])
  {
    _setType();
    _setParentClasses();
  }
  Byte::~Byte()
  {
    _finalize();
  }
}
