#ifndef __DAQBuilderByte_HH__
#define __DAQBuilderByte_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class Byte : public Number
  {
  protected : 
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual Cloneable *                clone() const ;
  public :
    Byte();
    Byte( const DByte&     value );
    Byte( const Byte & value );
    Byte( const Number  & value );
    Byte( const DString & value  );
    virtual ~Byte();
  public :
    const DByte &                    get() const ;
    void                             set(const DByte & b );
    void                             toOpposite();
    virtual DByte   equlas( const Object * o ) const;
    Byte&              operator= ( const Byte  & right );
    Byte&              operator= ( const DByte    & right );
  };
  inline void                            Byte::toOpposite()
  {
    _value._byteValue = !(_value._byteValue);
  }
  inline void          Byte::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void      Byte::set(const DByte & b )
  {
    _value._byteValue=b;
  }
  inline const DByte&        Byte::get() const 
  {
    return getValue()._byteValue;
  }
  inline void         Byte::_setType() 
  {
     this -> _type = "Byte";
  }
  inline DByte         Byte::equlas( const Object * o ) const
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._byteValue == ((Byte*)o)->getValue()._byteValue;
  }
  inline Byte& Byte::operator=( const Byte& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
  inline Byte&           Byte::operator= ( const DByte    & right )
  {
    _eType=etByte;
    _value._byteValue=right;
    return *this;
  }
}
#endif
