#include <Primitives/DAQBuilderCharacter.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  Cloneable *                Character::clone() const
  {
    return (Cloneable*)new Character(*this);
  }
  Character::Character()
    :Number((DChar)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Character::Character(const DChar& value)
    :Number((DChar)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Character::Character( const Character & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Character::Character( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Character::Character( const DString  & value )
    :Number((DChar)value[0])
  {
    _setType();
    _setParentClasses();
  }
  Character::~Character()
  {
    _finalize();
  }
}
