#ifndef __DAQBuilderCharacter_HH__
#define __DAQBuilderCharacter_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class Character : public Number
  {
  protected : 
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual Cloneable *                clone() const ;
  public :
    Character();
    Character( const DChar&     value );
    Character( const Character & value );
    Character( const Number  & value );
    Character( const DString & value  );
    virtual ~Character();
  public :
    const DChar &                    get() const ;
    void                             set(const DChar & b );
    void                             toOpposite();
    virtual DChar   equlas( const Object * o ) const;
    Character&              operator= ( const Character  & right );
    Character&              operator= ( const DChar    & right );
  };
  inline void                            Character::toOpposite()
  {
    _value._charValue = !(_value._charValue);
  }
  inline void          Character::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void      Character::set(const DChar & b )
  {
    _value._charValue=b;
  }
  inline const DChar&        Character::get() const 
  {
    return getValue()._charValue;
  }
  inline void         Character::_setType() 
  {
     this -> _type = "Character";
  }
  inline DChar         Character::equlas( const Object * o ) const
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._charValue == ((Character*)o)->getValue()._charValue;
  }
  inline Character& Character::operator=( const Character& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
  inline Character&           Character::operator= ( const DChar    & right )
  {
    _eType=etChar;
    _value._charValue=right;
    return *this;
  }
}
#endif
