#include <Primitives/DAQBuilderDouble.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
 Cloneable *                Double::clone() const 
 {
   return (Cloneable*)new Double(*this);
 }
  Double::Double()
    :Number((DDouble)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Double::Double( const DDouble & value )
    :Number((DDouble)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Double::Double( const Double & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Double::Double( const DString & value )
    :Number((DDouble)::atof(value.c_str()))
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  
  Double::Double( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }

  Double::~Double()
  {
    _finalize();
  }
}
