#ifndef __DAQBuilderDouble_HH__
#define __DAQBuilderDouble_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class Double : public Number
  {
  protected : 
//    virtual               void _finalize(){;}
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public:
    virtual Cloneable *                clone() const ;
  public :
    Double();
    Double( const DDouble    & value );
    Double( const Double & value );
    Double( const Number  & value );
    Double( const DString & value );
    virtual ~Double();
  public :
    const DDouble &      get() const ;
    void              set(const DDouble & i );
    DBool       equals( const Object * o ) const; 
    DBool       equals( const DDouble& o )const;
    Double&          operator= ( const Double & right );
  };
  inline void      Double::set(const DDouble & i )
  {
    _value._doubleValue=i;
  }
  inline const DDouble&        Double::get() const 
  {
    return getValue()._doubleValue;
  }
  inline void          Double::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void         Double::_setType() 
  {
     this -> _type = "Double";
  }
  inline DBool         Double::equals( const Object * o ) const 
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._doubleValue == ((Number*)o)->getValue()._doubleValue;
  }
  inline DBool         Double::equals( const DDouble& o )const
  {
    Double tmp(o);
    return equals(&tmp);
  }
  inline Double& Double::operator=( const Double& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
}
#endif
