#include <Primitives/DAQBuilderFloat.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
 Cloneable *                Float::clone() const 
 {
   return (Cloneable*)new Float(*this);
 }
  Float::Float()
    :Number((DFloat)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Float::Float( const DFloat & value )
    :Number((DFloat)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Float::Float( const Float & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Float::Float( const DString & value )
    :Number((DFloat)::atof(value.c_str()))
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  
  Float::Float( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }

  Float::~Float()
  {
    _finalize();
  }
}
