#ifndef __DAQBuilderFloat_HH__
#define __DAQBuilderFloat_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class Float : public Number
  {
  protected : 
//    virtual               void _finalize(){;}
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public:
    virtual Cloneable *                clone() const ;
  public :
    Float();
    Float( const DFloat    & value );
    Float( const Float & value );
    Float( const Number  & value );
    Float( const DString & value );
    virtual ~Float();
  public :
    const DFloat &      get() const ;
    void              set(const DFloat & i );
    DBool       equals( const Object * o ) const; 
    DBool       equals( const DFloat& o )const;
    Float&          operator= ( const Float & right );
  };
  inline void      Float::set(const DFloat & i )
  {
    _value._floatValue=i;
  }
  inline const DFloat&        Float::get() const 
  {
    return getValue()._floatValue;
  }
  inline void          Float::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void         Float::_setType() 
  {
     this -> _type = "Float";
  }
  inline DBool         Float::equals( const Object * o ) const 
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._floatValue == ((Number*)o)->getValue()._floatValue;
  }
  inline DBool         Float::equals( const DFloat& o )const
  {
    Float tmp(o);
    return equals(&tmp);
  }
  inline Float& Float::operator=( const Float& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
}
#endif
