#include <Primitives/DAQBuilderInteger.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
 Cloneable *                Integer::clone() const 
 {
   return (Cloneable*)new Integer(*this);
 }
  Integer::Integer()
    :Number((DInt)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Integer::Integer( const DInt & value )
    :Number((DInt)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Integer::Integer( const Integer & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Integer::Integer( const DString & value )
    :Number((DInt)::atoi(value.c_str()))
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  
  Integer::Integer( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }

  Integer::~Integer()
  {
    _finalize();
  }
}
