#ifndef __DAQBuilderInteger_HH__
#define __DAQBuilderInteger_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class Integer : public Number
  {
  protected : 
//    virtual               void _finalize(){;}
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public:
    virtual Cloneable *                clone() const ;
  public :
    Integer();
    Integer( const DInt    & value );
    Integer( const Integer & value );
    Integer( const Number  & value );
    Integer( const DString & value );
    virtual ~Integer();
  public :
    const DInt &      get() const ;
    void              set(const DInt & i );
    DBool       equals( const Object * o ) const; 
    DBool       equals( const DInt& o )const;
    Integer&          operator= ( const Integer & right );
  };
  inline void      Integer::set(const DInt & i )
  {
    _value._intValue=i;
  }
  inline const DInt&        Integer::get() const 
  {
    return getValue()._intValue;
  }
  inline void          Integer::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void         Integer::_setType() 
  {
     this -> _type = "Integer";
  }
  inline DBool         Integer::equals( const Object * o ) const 
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._intValue == ((Number*)o)->getValue()._intValue;
  }
  inline DBool         Integer::equals( const DInt& o )const
  {
    Integer tmp(o);
    return equals(&tmp);
  }
  inline Integer& Integer::operator=( const Integer& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
}
#endif
