#include <Primitives/DAQBuilderLong.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
 Cloneable *                Long::clone() const 
 {
   return (Cloneable*)new Long(*this);
 }
  Long::Long()
    :Number((DLong)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Long::Long( const DLong & value )
    :Number((DLong)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Long::Long( const Long & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Long::Long( const DString & value )
    :Number((DLong)::atol(value.c_str()))
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  
  Long::Long( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }

  Long::~Long()
  {
    _finalize();
  }
}
