#ifndef __DAQBuilderLong_HH__
#define __DAQBuilderLong_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class Long : public Number
  {
  protected : 
    //virtual               void _finalize(){;}
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public:
    virtual Cloneable *                clone() const ;
    Long();
    Long( const DLong    & value );
    Long( const Long & value );
    Long( const Number  & value );
    Long( const DString & value );
    virtual ~Long();
  public :
    const DLong &      get() const ;
    void              set(const DLong & i );
    DBool       equals( const Object * o ) const; 
    DBool       equals( const DLong& o )const;
    Long&          operator= ( const Long & right );
  };
  inline void      Long::set(const DLong & i )
  {
    _value._longValue=i;
  }
  inline const DLong&        Long::get() const 
  {
    return getValue()._longValue;
  }
  inline void          Long::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void         Long::_setType() 
  {
     this -> _type = "Long";
  }
  inline DBool         Long::equals( const Object * o ) const 
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._longValue == ((Number*)o)->getValue()._longValue;
  }
  inline DBool         Long::equals( const DLong& o )const
  {
    Long tmp(o);
    return equals(&tmp);
  }
  inline Long& Long::operator=( const Long& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
}
#endif
