#include <Primitives/DAQBuilderNumber.hh>
#include <Primitives/DAQBuilderString.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>

namespace DAQBuilder
{

  ByteArray                       Number::serialize()
  {
    ByteArrayOutputStream aBAO;
    PrimitiveDataOutputStream aPDO(&aBAO);
    
    aPDO.writeShort((DShort)_eType);

    switch(_eType)
      { 
      case etShort:
        aPDO.writeShort( _value._shortValue);
	break;
      case etInt:
        aPDO.writeInt( _value._intValue);
	break;
      case etLong:
        aPDO.writeLong( _value._longValue);
	break;
      case etUShort:
        aPDO.writeUShort( _value._ushortValue);
	break;
      case etUInt:
        aPDO.writeUInt( _value._uintValue);
	break;
      case etULong:
        aPDO.writeULong( _value._ulongValue);
	break;
     case etFloat:
        aPDO.writeFloat( _value._floatValue);
	break;
      case etDouble:
        aPDO.writeDouble( _value._doubleValue);
	break;
      case etChar:
        aPDO.writeChar( _value._charValue);
	break;
      case etUChar:
      case etByte:
        aPDO.writeByte( _value._byteValue);
	break;
      case etBool:
        aPDO.writeBool( _value._boolValue);
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    return aBAO.toByteArray();
  }
  void                       Number::serialize( DByte *& byteArray , DULong & byteArraySize )
  {
    ByteArrayOutputStream aBAO;
    PrimitiveDataOutputStream aPDO(&aBAO);
    
    aPDO.writeShort((DShort)_eType);

    switch(_eType)
      { 
      case etShort:
        aPDO.writeShort( _value._shortValue);
	break;
      case etInt:
        aPDO.writeInt( _value._intValue);
	break;
      case etLong:
        aPDO.writeLong( _value._longValue);
	break;
      case etUShort:
        aPDO.writeUShort( _value._ushortValue);
	break;
      case etUInt:
        aPDO.writeUInt( _value._uintValue);
	break;
      case etULong:
        aPDO.writeULong( _value._ulongValue);
	break;
     case etFloat:
        aPDO.writeFloat( _value._floatValue);
	break;
      case etDouble:
        aPDO.writeDouble( _value._doubleValue);
	break;
      case etChar:
        aPDO.writeChar( _value._charValue);
	break;
      case etUChar:
      case etByte:
        aPDO.writeByte( _value._byteValue);
	break;
      case etBool:
        aPDO.writeBool( _value._boolValue);
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    aBAO.toByteArray(byteArray,byteArraySize);
  }
  void                       Number::unSerialize( DByte * byteArray , const DULong& byteArraySize )
  {
    ByteArrayInputStream aBAI( byteArray,byteArraySize);
    PrimitiveDataInputStream aPDI(&aBAI);
    
    _eType = (ElementType)aPDI.readShort();
    switch(_eType)
      { 
      case etShort:
      _value._shortValue = aPDI.readShort();
	break;
      case etInt:
      _value._intValue  = aPDI.readInt();
	break;
      case etLong:
      _value._longValue = aPDI.readLong();
	break;
      case etUShort:
      _value._ushortValue = aPDI.readUShort();
	break;
      case etUInt:
      _value._uintValue =  aPDI.readUInt();
	break;
      case etULong:
      _value._ulongValue = aPDI.readULong();
	break;
      case etFloat:
      _value._floatValue = aPDI.readFloat();
	break;
      case etDouble:
      _value._doubleValue = aPDI.readDouble();
	break;
      case etChar:
      _value._charValue = aPDI.readChar();
	break;
      case etUChar:
      case etByte:
      _value._byteValue = aPDI.readByte();
	break;
      case etBool:
      _value._boolValue = aPDI.readBool();
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    //std::cout<<"Type : "<<_eType<<std::endl;
  }
  Cloneable *                Number::clone() const 
  {
    return (Cloneable*) new Number(*this);
  }
  DBool          Number::equals( const Object * o) const 
  {
    if(!findParent("Number",o)) 
      return false;
    return equals(*((Number*)o));
  }
  DBool          Number::equals( const Number & o) const 
  {
    switch(_eType)
      { 
      case etShort:
        return _value._shortValue == o._value._shortValue;
	break;
      case etInt:
        return _value._intValue ==  o._value._intValue;
	break;
      case etLong:
        return _value._longValue ==  o._value._longValue;
	break;
      case etUShort:
        return _value._ushortValue ==  o._value._ushortValue;
	break;
      case etUInt:
        return _value._uintValue ==  o._value._uintValue;
	break;
      case etULong:
        return _value._ulongValue ==  o._value._ulongValue;
	break;
      case etFloat:
        return _value._floatValue ==  o._value._floatValue;
	break;
      case etDouble:
        return _value._doubleValue ==  o._value._doubleValue;
	break;
      case etChar:
        return _value._charValue ==  o._value._charValue;
	break;
      case etUChar:
        return _value._ucharValue == o._value._ucharValue ;
	break;
      case etByte:
        return _value._byteValue == o._value._byteValue;
	break;
      case etBool:
        return _value._boolValue == o._value._boolValue;
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    return false;
  }
  
  DBool Number::isZero() const
  {
    switch(_eType)
      { 
      case etShort:
        return _value._shortValue == 0;
	break;
      case etInt:
	return _value._intValue == 0;
	break;
      case etLong:
	return _value._longValue == 0;
	break;
      case etUShort:
        return _value._ushortValue == 0;
	break;
      case etUInt:
	return _value._uintValue == 0;
	break;
      case etULong:
	return _value._ulongValue == 0;
	break;
      case etFloat:
	return _value._floatValue == 0.0F;
	break;
      case etDouble:
	return _value._doubleValue == 0.0F;
	break;
      case etChar:
	return _value._charValue == 0;
	break;
      case etUChar:
	return _value._ucharValue == 0;
	break;
      case etByte:
	return _value._byteValue == 0;
	break;
      case etBool:
        return _value._boolValue == 0;
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
	break;
      }
    return false;
  }
  void              Number::increment()
  {
    switch(_eType)
      { 
      case etShort:
        _value._shortValue += ((DShort)1);
	break;
      case etInt:
        _value._intValue += ((DInt)1);
	break;
      case etLong:
        _value._longValue += ((DLong)1);
	break;
      case etUShort:
        _value._ushortValue += ((DUShort)1);
	break;
      case etUInt:
        _value._uintValue += ((DUInt)1);
	break;
      case etULong:
        _value._ulongValue += ((DULong)1);
	break;
      case etFloat:
        _value._floatValue += ((DFloat)1.0);
	break;
      case etDouble:
        _value._doubleValue += ((DDouble)1.0);
	break;
      case etChar:
        _value._charValue += ((DChar)1);
	break;
      case etUChar:
        _value._ucharValue += ((DUChar)1);
	break;
      case etByte:
        _value._byteValue += ((DByte)1);
	break;
      case etBool:
        _value._boolValue += ((DBool)1);
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
  }

  void              Number::decrement()
  {
    switch(_eType)
      { 
      case etShort:
        _value._shortValue -= ((DShort)1);
	break;
      case etInt:
        _value._intValue -= ((DInt)1);
	break;
      case etLong:
        _value._longValue -= ((DLong)1);
	break;
      case etUShort:
        _value._ushortValue -= ((DUShort)1);
	break;
      case etUInt:
        _value._uintValue -= ((DUInt)1);
	break;
      case etULong:
        _value._ulongValue -= ((DULong)1);
	break;
      case etFloat:
        _value._floatValue -= ((DFloat)1.0);
	break;
      case etDouble:
        _value._doubleValue -= ((DDouble)1.0);
	break;
      case etChar:
        _value._charValue -= ((DChar)1);
	break;
      case etUChar:
        _value._ucharValue -= ((DUChar)1);
	break;
      case etByte:
        _value._byteValue -= ((DByte)1);
	break;
      case etBool:
        _value._boolValue -= ((DBool)1);
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
  }

  void              Number::add( const Number * n)
  {
    PrimitiveValue value = n -> getValue() ;    
    switch(_eType)
      { 
      case etShort:
        _value._shortValue += ((DShort)value._shortValue);
	break;
      case etInt:
        _value._intValue += ((DInt)value._intValue);
	break;
      case etLong:
        _value._longValue += ((DLong)value._longValue);
	break;
      case etUShort:
        _value._ushortValue += ((DUShort)value._ushortValue);
	break;
      case etUInt:
        _value._uintValue += ((DUInt)value._uintValue);
	break;
      case etULong:
        _value._ulongValue += ((DULong)value._ulongValue);
	break;
      case etFloat:
        _value._floatValue += ((DFloat)value._floatValue);
	break;
      case etDouble:
        _value._doubleValue += ((DDouble)value._doubleValue);
	break;
      case etChar:
        _value._charValue += ((DChar)value._charValue);
	break;
      case etUChar:
        _value._ucharValue += ((DUChar)value._ucharValue);
	break;
      case etByte:
        _value._byteValue += ((DByte)value._byteValue);
	break;
      case etBool:
        _value._boolValue += ((DBool)value._boolValue);
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
  }
  void              Number::sub( const Number * n)
  {
    PrimitiveValue value = n -> getValue() ;    
    switch(_eType)
      { 
      case etShort:
        _value._shortValue -= ((DShort)value._shortValue);
	break;
      case etInt:
        _value._intValue -= ((DInt)value._intValue);
	break;
      case etLong:
        _value._longValue -= ((DLong)value._longValue);
	break;
      case etUShort:
        _value._ushortValue -= ((DUShort)value._ushortValue);
	break;
      case etUInt:
        _value._uintValue -= ((DUInt)value._uintValue);
	break;
      case etULong:
        _value._ulongValue -= ((DULong)value._ulongValue);
	break;
      case etFloat:
        _value._floatValue -= ((DFloat)value._floatValue);
	break;
      case etDouble:
        _value._doubleValue -= ((DDouble)value._doubleValue);
	break;
      case etChar:
        _value._charValue -= ((DChar)value._charValue);
	break;
      case etUChar:
        _value._ucharValue -= ((DUChar)value._ucharValue);
	break;
      case etByte:
        _value._byteValue -= ((DByte)value._byteValue);
	break;
      case etBool:
        _value._boolValue -= ((DBool)value._boolValue);
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
  }
  void              Number::div( const Number * n)
      throw( ArithmeticException * )
  {
    if( n->isZero() )
      {
	ArithmeticException *e = new ArithmeticException(" divide Zero Value !!");
	e -> insert("Location","  void              Number::div( const Number*)");
        throw e;
      }
    PrimitiveValue value = n -> getValue() ;    
    switch(_eType)
      { 
      case etShort:
        _value._shortValue /= ((DShort)value._shortValue);
	break;
      case etInt:
        _value._intValue /= ((DInt)value._intValue);
	break;
      case etLong:
        _value._longValue /= ((DLong)value._longValue);
	break;
      case etUShort:
        _value._ushortValue /= ((DUShort)value._ushortValue);
	break;
      case etUInt:
        _value._uintValue /= ((DUInt)value._uintValue);
	break;
      case etULong:
        _value._ulongValue /= ((DULong)value._ulongValue);
	break;
      case etFloat:
        _value._floatValue /= ((DFloat)value._floatValue);
	break;
      case etDouble:
        _value._doubleValue /= ((DDouble)value._doubleValue);
	break;
      case etChar:
        _value._charValue /= ((DChar)value._charValue);
	break;
      case etUChar:
        _value._ucharValue /= ((DUChar)value._ucharValue);
	break;
      case etByte:
        _value._byteValue /= ((DByte)value._byteValue);
	break;
      case etBool:
        _value._boolValue /= ((DBool)value._boolValue);
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
  }
  void              Number::mul( const Number * n)
  {
    PrimitiveValue value = n -> getValue() ;    
    switch(_eType)
      { 
      case etShort:
        _value._shortValue *= ((DShort)value._shortValue);
	break;
      case etInt:
        _value._intValue *= ((DInt)value._intValue);
	break;
      case etLong:
        _value._longValue *= ((DLong)value._longValue);
	break;
      case etUShort:
        _value._ushortValue *= ((DUShort)value._ushortValue);
	break;
      case etUInt:
        _value._uintValue *= ((DUInt)value._uintValue);
	break;
      case etULong:
        _value._ulongValue *= ((DULong)value._ulongValue);
	break;
      case etFloat:
        _value._floatValue *= ((DFloat)value._floatValue);
	break;
      case etDouble:
        _value._doubleValue *= ((DDouble)value._doubleValue);
	break;
      case etChar:
        _value._charValue *= ((DChar)value._charValue);
	break;
      case etUChar:
        _value._ucharValue *= ((DUChar)value._ucharValue);
	break;
      case etByte:
        _value._byteValue *= ((DByte)value._byteValue);
	break;
      case etBool:
        _value._boolValue *= ((DBool)value._boolValue);
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
  }
  Number::Number( const DShort&   n)
    :SerializableObject()
  {
    _eType = etShort;
    _value._shortValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const DInt&     n)
    :SerializableObject()
  {
    _eType = etInt;
    _value._intValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const DLong&    n)
    :SerializableObject()
  {
    _eType = etLong;
    _value._longValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const DUShort&  n)
    :SerializableObject()
  {
    _eType = etUShort;
    _value._ushortValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const DUInt&    n)
    :SerializableObject()
  {
    _eType = etUInt;
    _value._uintValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const DULong&   n)
    :SerializableObject()
  {
    _eType = etULong;
    _value._ulongValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const DFloat&   n)
    :SerializableObject()
  {
    _eType = etFloat;
    _value._floatValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const DDouble&  n)
    :SerializableObject()
  {
    _eType = etDouble;
    _value._doubleValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const DChar&    n)
    :SerializableObject()
  {
    _eType = etChar;
    _value._charValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const DUChar&   n)
    :SerializableObject()
  {
    _eType = etUChar;
    _value._ucharValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const DBool&   n)
    :SerializableObject()
  {
    _eType = etBool;
    _value._boolValue = n;
    _setType();
    _setParentClasses();
  }
  Number::Number( const Number&   right)
    :SerializableObject(*((SerializableObject*)&right)),_eType(right._eType),_value(right._value)
  {
    _setType();
    _setParentClasses();
  }
  Number::Number( const Number*&  n)
    :SerializableObject(*((SerializableObject*)n)),_eType(n->_eType),_value(n->_value)
  {
    _setType();
    _setParentClasses();
  }
  Number::Number()
    :SerializableObject()
  {
    _setType();
    _setParentClasses();
  }
  Number::~Number()
  {
    _finalize();
  }
  
  const DString Number::toString() const 
  {
   DString aString;// = _toStringHeader();
   aString +="Type : ";
    switch(_eType)
      { 
      case etShort:
	aString +=" DShort\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DLong) _value._shortValue);
	break;
      case etInt:
	aString +=" DInt\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DLong)_value._intValue);
	break;
      case etLong:
	aString +=" DLong\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DLong)_value._longValue);
	break;
      case etUShort:
	aString +=" DUShort\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DULong)_value._ushortValue);
	break;
      case etUInt:
	aString +=" DUInt\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DULong)_value._uintValue);
	break;
      case etULong:
	aString +=" DULong\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DULong)_value._ulongValue);
	break;
      case etFloat:
	aString +=" DFloat\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DDouble)_value._floatValue);
	break;
      case etDouble:
	aString +=" DDouble\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DDouble)_value._doubleValue);
	break;
      case etChar:
	aString +=" DChar\n";
	aString +="Vlaue: ";
        aString.append((const char*)&_value._charValue);
	break;
      case etUChar:
	aString +=" DUChar\n";
	aString +="Vlaue: ";
        aString.append((const char*)&_value._ucharValue);
	break;
      case etByte:
	aString +=" DByte\n";
	aString +="Vlaue: ";
        aString.append((const char*)&_value._byteValue);
	break;
      case etBool:
	aString +=" DBool\n";
	aString +="Vlaue: ";
        _value._boolValue ? aString+=" true" :  aString+=" false" ;
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    //aString += _toStringFooter();
    return aString;
  }
  Number& Number::operator=( const Number& right )
  {
    *((SerializableObject*)this) = *((SerializableObject*)&right);
    _eType=right._eType;
    _value=right._value;
    return *this;
  }
  DBool   Number::operator   ==(const Number & right ) const 
  {
    DBool aBool = *((SerializableObject*)this) ==  *((SerializableObject*)&right);
    switch(_eType)
      { 
      case etShort:
        aBool |=  _value._shortValue == right._value._shortValue;
	break;
      case etInt:
        aBool |= _value._intValue ==  right._value._intValue;
	break;
      case etLong:
        aBool |= _value._longValue ==  right._value._longValue;
	break;
      case etUShort:
        aBool |= _value._ushortValue ==  right._value._ushortValue;
	break;
      case etUInt:
        aBool |= _value._uintValue ==  right._value._uintValue;
	break;
      case etULong:
        aBool |= _value._ulongValue ==  right._value._ulongValue;
	break;
      case etFloat:
        aBool |= _value._floatValue ==  right._value._floatValue;
	break;
      case etDouble:
        aBool |= _value._doubleValue ==  right._value._doubleValue;
	break;
      case etChar:
        aBool |= _value._charValue ==  right._value._charValue;
	break;
      case etUChar:
        aBool |= _value._ucharValue == right._value._ucharValue ;
	break;
      case etByte:
        aBool |= _value._byteValue == right._value._byteValue;
	break;
      case etBool:
        aBool |= _value._boolValue == right._value._boolValue;
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    return aBool;
  }
  DBool   Number::operator   !=(const Number & right ) const 
  {
    DBool aBool = *((SerializableObject*)this) !=  *((SerializableObject*)&right);
    switch(_eType)
      { 
      case etShort:
        aBool |=  _value._shortValue != right._value._shortValue;
	break;
      case etInt:
        aBool |= _value._intValue !=  right._value._intValue;
	break;
      case etLong:
        aBool |= _value._longValue !=  right._value._longValue;
	break;
      case etUShort:
        aBool |= _value._ushortValue !=  right._value._ushortValue;
	break;
      case etUInt:
        aBool |= _value._uintValue !=  right._value._uintValue;
	break;
      case etULong:
        aBool |= _value._ulongValue !=  right._value._ulongValue;
	break;
      case etFloat:
        aBool |= _value._floatValue !=  right._value._floatValue;
	break;
      case etDouble:
        aBool |= _value._doubleValue !=  right._value._doubleValue;
	break;
      case etChar:
        aBool |= _value._charValue !=  right._value._charValue;
	break;
      case etUChar:
        aBool |= _value._ucharValue != right._value._ucharValue ;
	break;
      case etByte:
        aBool |= _value._byteValue != right._value._byteValue;
	break;
      case etBool:
        aBool |= _value._boolValue != right._value._boolValue;
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    return aBool;
  }
}
