#ifndef _DAQBuilderNumber_HH_
#define _DAQBuilderNumber_HH_
#include <DAQBuilderSerializableObject.hh>
#include <Exception/DAQBuilderArithmeticException.hh>
#include <System/DAQBuilderSerializableObjectLoader.hh>

namespace DAQBuilder
{
  class Number : public SerializableObject 
  {    
  protected:
    //virtual  void              _finalize(){;}
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    ElementType                _eType;
    PrimitiveValue             _value;
  public :
    virtual void                       serialize( DByte *& , DULong &  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  public :
    virtual  const DString  toString() const ;
    virtual  DBool          equals( const Object * o) const ;
    virtual  DBool          equals( const Number & o) const ;
  public :
    Number();
    Number( const DShort&);
    Number( const DInt&);
    Number( const DLong&);
    Number( const DUShort&);
    Number( const DUInt&);
    Number( const DULong&);
    Number( const DFloat&);
    Number( const DDouble&);
    Number( const DChar&);
    Number( const DUChar&);
    Number( const DBool&);
    Number( const Number&);
    Number( const Number*&);
    virtual ~Number();
  public:
    void              increment();
    void              decrement();
    void              add( const Number * n);
    void              sub( const Number * n);
    void              div( const Number * n)
      throw( ArithmeticException * );
    void              mul( const Number * n);

    const PrimitiveValue& getValue() const;
    virtual Number& operator=( const Number& right );
    virtual DBool   operator   ==(const Number & right ) const ;
    virtual DBool   operator   !=(const Number & right ) const ;
  public : 
    DBool isShort() const ;
    DBool isInt() const ;
    DBool isLong() const;
    DBool isUShort() const;
    DBool isUInt() const;
    DBool isULong() const;
    DBool isFloat() const;
    DBool isDouble() const;
    DBool isChar() const;
    DBool isUChar() const;
    DBool isBool() const;
    DBool isZero() const;
  };

  inline void   Number::_setType()
  {
    this -> _type = "Number";
  }
  inline void   Number::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("SerializableObject");
  }
  inline DBool Number::isShort() const 
  {
    return _eType == etShort;
  }
  inline DBool Number::isInt() const 
  {
    return _eType == etInt;
  }
  inline DBool Number::isLong() const
  {
    return _eType == etLong;
  }
  inline DBool Number::isUShort() const
  {
    return _eType == etUShort;
  }
  inline DBool Number::isUInt() const
  {
    return _eType == etUInt;
  }
  inline DBool Number::isULong() const
  {
    return _eType == etULong;
  }
  inline DBool Number::isFloat() const
  {
    return _eType == etFloat;
  }
  inline DBool Number::isDouble() const
  {
    return _eType == etDouble;
  }
  inline DBool Number::isChar() const
  {
    return _eType == etChar;
  }
  inline DBool Number::isUChar() const
  {
    return _eType == etUChar;
  }
  inline DBool Number::isBool() const
  {
    return _eType == etBool;
  }

  inline const PrimitiveValue& Number::getValue() const
  {
    return this -> _value;
  }
}
#endif
