#include <Primitives/DAQBuilderShort.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  Cloneable *                Short::clone() const 
  {
    return (Cloneable*)new Short(*this);
  }
  Short::Short()
    :Number((DShort)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Short::Short( const DShort & value )
    :Number((DShort)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Short::Short( const Short & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Short::Short( const DString & value )
    :Number((DShort)::atoi(value.c_str()))
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  
  Short::Short( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }

  Short::~Short()
  {
    _finalize();
  }
}
