#ifndef __DAQBuilderShort_HH__
#define __DAQBuilderShort_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class Short : public Number
  {
  protected : 
  //  virtual               void _finalize(){;}
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public:
    virtual Cloneable *                clone() const ;
  public :
    Short();
    Short( const DShort    & value );
    Short( const Short   & value );
    Short( const Number  & value );
    Short( const DString & value );
    virtual ~Short();
  public :
    const DShort &      get() const ;
    void              set(const DShort & i );
    DBool       equals( const Object * o ) const; 
    DBool       equals( const DShort& o )const;
    Short&          operator= ( const Short & right );
  };
  inline void      Short::set(const DShort & i )
  {
    _value._shortValue=i;
  }
  inline const DShort&        Short::get() const 
  {
    return getValue()._shortValue;
  }
  inline void          Short::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void         Short::_setType() 
  {
     this -> _type = "Short";
  }
  inline DBool         Short::equals( const Object * o ) const 
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._shortValue == ((Number*)o)->getValue()._shortValue;
  }
  inline DBool         Short::equals( const DShort& o )const
  {
    Short tmp(o);
    return equals(&tmp);
  }
  inline Short& Short::operator=( const Short& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
}
#endif
