#include <Primitives/DAQBuilderString.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>

namespace DAQBuilder
{
  String::String() 
     :DString()
  { 
    this -> _setType();
    this -> _setParentClasses();
  }

  String::String( const DChar      * str ) 
    : DString( str )
  {
    this -> _setType();
    this -> _setParentClasses(); 
  }
  
  String::String( const DString    & str )
    :DString( str )
  { 
    this -> _setType();
    this -> _setParentClasses(); 
  }
  
  String::String( const String & str ) 
    :DString( *((DString*)&str) )
  { 
    this -> _setType();
    this -> _setParentClasses(); 
  }
  String::~String()
  {
    this -> _finalize();
  }
  String&              String::operator= ( const String & right )
  {
    *((SerializableObject*)this) =  *((SerializableObject*)&right)  ;
    *((DString*)this)            =  *((DString*)&right)  ;
    return *this;
  }
  String&              String::operator= ( const DString & right )
  {
    *((DString*)this)            =  *((DString*)&right)  ;
    return *this;
  }
  
  
  const DString String::toString() const 
  {
    return (DString)*this;
  }
  ByteArray                  String::serialize()
  { 
    ByteArrayOutputStream aBAO;
    PrimitiveDataOutputStream aPDO(&aBAO);

    aPDO.writeString(*((DString*)this));
    return aBAO.toByteArray();
  }
  void                       String::serialize( DByte *& byteArray , DULong &  byteArraySize )
  {
    ByteArrayOutputStream aBAO;
    PrimitiveDataOutputStream aPDO(&aBAO);

    aPDO.writeString(*((DString*)this));
    aBAO.toByteArray(byteArray,byteArraySize);
  }
  void                       String::unSerialize( DByte *  byteArray , const DULong&  byteArraySize )
  {
    ByteArrayInputStream aBAI( byteArray , byteArraySize );
    PrimitiveDataInputStream aPDI(&aBAI);
    operator =(aPDI.readString());
  }
  Cloneable *                String::clone() const 
  {
    return (Cloneable*)new String(*this);
  }
  DBool String::equals( const Object * o ) const 
  {
    if( !equalTypes(o))
      return false;
    return ( (DString)(*this) == (DString)(*((String*)o)) );
  }
  DBool String::equals( const DString& o ) const 
  {
    String tmp(o);
    return equals(&tmp);
  }
  
  DBool String::equalsIgnoreCase( const Object * o ) const 
  {
    if( this -> equalTypes(o) )
      {      
	String * tmpStr =(String *)o;
	DInt   olength   = tmpStr -> length();
	DInt   tlength   = this   -> length();
	if( olength != tlength ) return false;
	DChar  *otmpDChar = new DChar[ olength ] ;
	DChar  *ttmpDChar = new DChar[ tlength ] ;
	strcpy( otmpDChar , tmpStr -> c_str() );
	strcpy( ttmpDChar , this   -> c_str() );
	DChar _o , _t ;
	DInt  i ; 
	for( i = 0 ;  i < olength ; i++ )
	  {
	    _o = ( DChar )tolower( (DInt)otmpDChar[ i ]);
	    _t = ( DChar )tolower( (DInt)ttmpDChar[ i ]);
	    otmpDChar[ i ] = _o;
	    ttmpDChar[ i ] = _t;
	  }
	String otmpStr( otmpDChar );
	String ttmpStr( ttmpDChar );
	delete [] otmpDChar;
	delete [] ttmpDChar;
	return otmpStr.equals( &ttmpStr );
      }
    return false;
  }
  DBool String::equalsIgnoreCase( const DString& o ) const 
  {
    String tmp(o);
    return equalsIgnoreCase(&tmp);
  }
  DInt String::parseInt()
  {
    DInt  retValue = 0;
    if( isDigit() )
      {
	DChar * cDInt = new DChar[ 255 ] ;
	::strcpy( cDInt , this->c_str());
	retValue = (DInt) ::atoi( cDInt );
	delete cDInt;
	return retValue; 
      }
    return retValue; 
  }

  DLong String::parseLong()
   {
     DLong  retValue = 0;
    if( this -> isDigit() )
      {
	DChar * cLong = new DChar[ 255 ] ;
	::strcpy( cLong , this->c_str());
	retValue = (DLong) ::atol( cLong );
	delete cLong;
	return retValue; 
      }
    return retValue; 
  }

  DBool String::isDigit() const 
  {
    DInt    length  = this -> length();
    DChar * tmpDChar = new DChar[ length ];
    
    ::strcpy( tmpDChar , this -> c_str());
    if( tmpDChar[0] == '-' )
    {
      DInt i ;
      for(  i = 1 ; i < length ; i ++ )
	{
	  if( isdigit( (DInt) tmpDChar[ i ]) == 0)
	    {
	      delete [] tmpDChar;
	      return false;
	    }
	}
    }
    else
      {
	DInt i ;
	for(  i = 0 ; i < length ; i ++ )
	  {
	  if( isdigit( (DInt) tmpDChar[ i ]) == 0)
	    {
	      delete [] tmpDChar;
	      return false;
	    }
	  }
      }
    return true;
  }
  
  const DString String::digitToString( const DLong& digit )
  {
    DString returnString;
    std::stringstream sBuffer(std::ios::in|std::ios::out);
    sBuffer << digit;
    sBuffer >> returnString;
    return returnString;
  }
  const DString String::digitToString( const DULong& digit )
  {
    DString returnString;
    std::stringstream sBuffer(std::ios::in|std::ios::out);
    sBuffer << digit;
    sBuffer >> returnString;
    return returnString;
  }

  const DString String::digitToString( const DDouble& digit )
  {

    DString returnString;
    std::stringstream sBuffer(std::ios::in|std::ios::out);
    sBuffer << digit;
    sBuffer >> returnString;
    return returnString;
  }
}
