#ifndef __DAQBuilderString_HH__
#define __DAQBuilderString_HH__
#include <DAQBuilderSerializableObject.hh>
#include <System/DAQBuilderSerializableObjectLoader.hh>

namespace DAQBuilder
{
  class String : public SerializableObject , public DString
  {
  protected:
    virtual  void              _finalize(){;}
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    String();
    String( const DChar      * str );
    String( const DString    & str );
    String( const String     & str );
    virtual ~String();
    String&              operator= ( const String & right );
    String&              operator= ( const DString & right );
  public :
    virtual void                       serialize(   DByte *& ,       DULong&  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  public :
    virtual const DString   toString() const ;
    virtual DInt   parseInt();
    virtual DLong  parseLong();
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const DString& o ) const ;
    virtual DBool  equalsIgnoreCase( const Object * o ) const ;
    virtual DBool  equalsIgnoreCase( const DString& o ) const ;
    virtual DBool  isDigit() const ;
   public :
    static  const DString digitToString( const DLong&   digit );
    static  const DString digitToString( const DULong&  digit );
    static  const DString digitToString( const DDouble& digit );
  };
  inline void String::_setType()
  {
    this -> _type ="String";
  }
  inline void String::_setParentClasses()
  {
    this -> _parentClasses.insert("Object");
    this -> _parentClasses.insert("DString");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("SerializableObject");
  }
}
#endif
