#include <Primitives/DAQBuilderUnsignedCharacter.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  Cloneable *                UnsignedCharacter::clone() const
  {
    return (Cloneable*)new UnsignedCharacter(*this);
  }
  UnsignedCharacter::UnsignedCharacter()
    :Number((DUChar)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedCharacter::UnsignedCharacter(const DUChar& value)
    :Number((DUChar)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedCharacter::UnsignedCharacter( const UnsignedCharacter & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedCharacter::UnsignedCharacter( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedCharacter::UnsignedCharacter( const DString  & value )
    :Number((DUChar)value[0])
  {
    _setType();
    _setParentClasses();
  }
  UnsignedCharacter::~UnsignedCharacter()
  {
    _finalize();
  }
}
