#ifndef __DAQBuilderUnsignedCharacter_HH__
#define __DAQBuilderUnsignedCharacter_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class UnsignedCharacter : public Number
  {
  protected : 
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual Cloneable *                clone() const ;
  public :
    UnsignedCharacter();
    UnsignedCharacter( const DUChar&     value );
    UnsignedCharacter( const UnsignedCharacter & value );
    UnsignedCharacter( const Number  & value );
    UnsignedCharacter( const DString & value  );
    virtual ~UnsignedCharacter();
  public :
    const DUChar &                    get() const ;
    void                             set(const DUChar & b );
    void                             toOpposite();
    virtual DUChar   equlas( const Object * o ) const;
    UnsignedCharacter&              operator= ( const UnsignedCharacter  & right );
    UnsignedCharacter&              operator= ( const DUChar    & right );
  };
  inline void                            UnsignedCharacter::toOpposite()
  {
    _value._ucharValue = !(_value._ucharValue);
  }
  inline void          UnsignedCharacter::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void      UnsignedCharacter::set(const DUChar & b )
  {
    _value._ucharValue=b;
  }
  inline const DUChar&        UnsignedCharacter::get() const 
  {
    return getValue()._ucharValue;
  }
  inline void         UnsignedCharacter::_setType() 
  {
     this -> _type = "UnsignedCharacter";
  }
  inline DUChar         UnsignedCharacter::equlas( const Object * o ) const
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._ucharValue == ((UnsignedCharacter*)o)->getValue()._ucharValue;
  }
  inline UnsignedCharacter& UnsignedCharacter::operator=( const UnsignedCharacter& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
  inline UnsignedCharacter&           UnsignedCharacter::operator= ( const DUChar    & right )
  {
    _eType=etUChar;
    _value._ucharValue=right;
    return *this;
  }
}
#endif
