#include <Primitives/DAQBuilderUnsignedInteger.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
 Cloneable *                UnsignedInteger::clone() const 
 {
   return (Cloneable*)new UnsignedInteger(*this);
 }
  UnsignedInteger::UnsignedInteger()
    :Number((DUInt)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedInteger::UnsignedInteger( const DUInt & value )
    :Number((DUInt)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedInteger::UnsignedInteger( const UnsignedInteger & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedInteger::UnsignedInteger( const DString & value )
    :Number((DUInt)::atoi(value.c_str()))
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  
  UnsignedInteger::UnsignedInteger( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }

  UnsignedInteger::~UnsignedInteger()
  {
    _finalize();
  }
}
