#ifndef __DAQBuilderUnsignedInteger_HH__
#define __DAQBuilderUnsignedInteger_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class UnsignedInteger : public Number
  {
  protected : 
//    virtual               void _finalize(){;}
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public:
    virtual Cloneable *                clone() const ;
  public :
    UnsignedInteger();
    UnsignedInteger( const DUInt    & value );
    UnsignedInteger( const UnsignedInteger & value );
    UnsignedInteger( const Number  & value );
    UnsignedInteger( const DString & value );
    virtual ~UnsignedInteger();
  public :
    const DUInt &      get() const ;
    void              set(const DUInt & i );
    DBool       equals( const Object * o ) const; 
    DBool       equals( const DUInt& o )const;
    UnsignedInteger&          operator= ( const UnsignedInteger & right );
  };
  inline void      UnsignedInteger::set(const DUInt & i )
  {
    _value._uintValue=i;
  }
  inline const DUInt&        UnsignedInteger::get() const 
  {
    return getValue()._uintValue;
  }
  inline void          UnsignedInteger::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void         UnsignedInteger::_setType() 
  {
     this -> _type = "UnsignedInteger";
  }
  inline DBool         UnsignedInteger::equals( const Object * o ) const 
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._uintValue == ((Number*)o)->getValue()._uintValue;
  }
  inline DBool         UnsignedInteger::equals( const DUInt& o )const
  {
    UnsignedInteger tmp(o);
    return equals(&tmp);
  }
  inline UnsignedInteger& UnsignedInteger::operator=( const UnsignedInteger& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
}
#endif
