#include <Primitives/DAQBuilderUnsignedLong.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
 Cloneable *                UnsignedLong::clone() const 
 {
   return (Cloneable*)new UnsignedLong(*this);
 }
  UnsignedLong::UnsignedLong()
    :Number((DULong)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedLong::UnsignedLong( const DULong & value )
    :Number((DULong)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedLong::UnsignedLong( const UnsignedLong & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedLong::UnsignedLong( const DString & value )
    :Number((DULong)::atol(value.c_str()))
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  
  UnsignedLong::UnsignedLong( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }

  UnsignedLong::~UnsignedLong()
  {
    _finalize();
  }
}
