#ifndef __DAQBuilderUnsignedLong_HH__
#define __DAQBuilderUnsignedLong_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class UnsignedLong : public Number
  {
  protected : 
    //virtual               void _finalize(){;}
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public:
    virtual Cloneable *                clone() const ;
    UnsignedLong();
    UnsignedLong( const DULong    & value );
    UnsignedLong( const UnsignedLong & value );
    UnsignedLong( const Number  & value );
    UnsignedLong( const DString & value );
    virtual ~UnsignedLong();
  public :
    const DULong &      get() const ;
    void              set(const DULong & i );
    DBool       equals( const Object * o ) const; 
    DBool       equals( const DULong& o )const;
    UnsignedLong&          operator= ( const UnsignedLong & right );
  };
  inline void      UnsignedLong::set(const DULong & i )
  {
    _value._ulongValue=i;
  }
  inline const DULong&        UnsignedLong::get() const 
  {
    return getValue()._ulongValue;
  }
  inline void          UnsignedLong::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void         UnsignedLong::_setType() 
  {
     this -> _type = "UnsignedLong";
  }
  inline DBool         UnsignedLong::equals( const Object * o ) const 
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._ulongValue == ((Number*)o)->getValue()._ulongValue;
  }
  inline DBool         UnsignedLong::equals( const DULong& o )const
  {
    UnsignedLong tmp(o);
    return equals(&tmp);
  }
  inline UnsignedLong& UnsignedLong::operator=( const UnsignedLong& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
}
#endif
