#include <Primitives/DAQBuilderUnsignedShort.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  Cloneable *                UnsignedShort::clone() const 
  {
    return (Cloneable*)new UnsignedShort(*this);
  }
  UnsignedShort::UnsignedShort()
    :Number((DUShort)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedShort::UnsignedShort( const DUShort & value )
    :Number((DUShort)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedShort::UnsignedShort( const UnsignedShort & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  UnsignedShort::UnsignedShort( const DString & value )
    :Number((DUShort)::atoi(value.c_str()))
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  
  UnsignedShort::UnsignedShort( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }

  UnsignedShort::~UnsignedShort()
  {
    _finalize();
  }
}
