#ifndef __DAQBuilderUnsignedShort_HH__
#define __DAQBuilderUnsignedShort_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class UnsignedShort : public Number
  {
  protected : 
  //  virtual               void _finalize(){;}
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public:
    virtual Cloneable *                clone() const ;
  public :
    UnsignedShort();
    UnsignedShort( const DUShort    & value );
    UnsignedShort( const UnsignedShort   & value );
    UnsignedShort( const Number  & value );
    UnsignedShort( const DString & value );
    virtual ~UnsignedShort();
  public :
    const DUShort &      get() const ;
    void              set(const DUShort & i );
    DBool       equals( const Object * o ) const; 
    DBool       equals( const DUShort& o )const;
    UnsignedShort&          operator= ( const UnsignedShort & right );
  };
  inline void      UnsignedShort::set(const DUShort & i )
  {
    _value._ushortValue=i;
  }
  inline const DUShort&        UnsignedShort::get() const 
  {
    return getValue()._ushortValue;
  }
  inline void          UnsignedShort::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void         UnsignedShort::_setType() 
  {
     this -> _type = "UnsignedShort";
  }
  inline DBool         UnsignedShort::equals( const Object * o ) const 
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._ushortValue == ((Number*)o)->getValue()._ushortValue;
  }
  inline DBool         UnsignedShort::equals( const DUShort& o )const
  {
    UnsignedShort tmp(o);
    return equals(&tmp);
  }
  inline UnsignedShort& UnsignedShort::operator=( const UnsignedShort& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
}
#endif
