#include <Run/DAQBuilderAction.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>
#include <System/DAQBuilderObjectRegistry.hh>
#include <System/DAQBuilderClassLoader.hh>
#include <Util/DAQBuilderPattern.hh>
#include <Util/DAQBuilderMatcher.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Instance/DAQBuilderInstance.hh>

namespace DAQBuilder
{
//static const DString gPattern ="\\(\\w+\\)?[ \\t\\r]*\\=?[ \\t\\r]*\\(\\w*\\)[ \\t\\r]*->[ \\t\\r]*\\(\\w+\\)(\\(\\([ \\t\\r]*[a-zA-Z0-9,.\"]+[ \\t\\r]*,?\\)*\\));?";  
//static const DString gPattern ="\\(\\([a-zA-Z0-9_.]+\\)\\=\\)?\\([a-zA-Z0-9_.]+\\)->\\([a-zA-Z0-9_.]+\\)(\\(\\([a-zA-Z0-9_,./\"]+,?\\)*\\));";  
static const DString gPattern ="\\(\\([a-zA-Z0-9_]+\\)\\=\\)?\\([a-zA-Z0-9_]+\\).\\([a-zA-Z0-9_]+\\)(\\(\\([a-zA-Z0-9,_./\"]+,?\\)*\\));";  
static const DString gStringPattern     ="\"\\([a-zA-Z0-9._,/]+\\)\"";
static const DString gPrimitivesPattern ="\\([a-zA-Z]+\\)_\\([a-zA-Z0-9.]+\\)";
  void              Action::_finalize()
  {;}
  
  void Action::_parse()
    throw( PatternSyntaxException * )
  {
    Pattern aPattern = Pattern::compile(gPattern);
    Matcher aMatcher = aPattern.matcher(_command);
    //std::cout<<"command="<<_command<<std::endl;
    if(aMatcher.matches()){
      _returnValueName = aMatcher.group(2);
      _objectName      = aMatcher.group(3);
      _methodName      = aMatcher.group(4);
      if(_objectName.empty()){
         _objectName=_returnValueName;
         _returnValueName.clear();
      }
      DString arguments= aMatcher.group(5);
      
     if(!arguments.empty()){
      DChar*  argC     = new DChar[ arguments.size()+1 ];
      strcpy(argC,arguments.c_str());
     //std::cout<<"arguments="<<argC<<std::endl;
      DChar * tmp = strtok(argC,", ");
      if(tmp!=NULL)
	_argumentsNames.push_back(tmp);
      while(true){
      DChar * tmp = strtok(NULL,", ");
	if(tmp==NULL)
	  break;
	_argumentsNames.push_back(tmp);
      }
      delete [] argC;
     }
    }
    else
      {
	PatternSyntaxException * e = new PatternSyntaxException("SyntaxError"); 
	e -> insert("Location","Action::_parse( const DString& command )");
	e -> insert("Pattern",_command);
	throw e;
      }
  }

  Action::Action()
    :SerializableObject(),_isChecked(false)
  {
    _setType();
    _setParentClasses();
  }

  Action::Action( const DString& command )
      throw( PatternSyntaxException * )
    :SerializableObject(),_isChecked(false),_command(command)
  {
    _setType();
    _setParentClasses();
    _parse();
  }
  Action::Action( const Action& right)
    :SerializableObject(*((SerializableObject*)&right)),_isChecked(right._isChecked),
     _command(right._command),_objectName(right._objectName),_methodName(right._methodName),
     _returnValueName(right._returnValueName),_argumentsNames(right._argumentsNames)
  {
  }
  Action::~Action()
  {
    _finalize();
  }
  Action&              Action::operator= ( const Action & right )
  {
    *((Object*)this) =  *((Object*)&right);
    _isChecked       = right._isChecked;
    _command         = right._command;
    _objectName      = right._objectName;
    _methodName      = right._methodName;
    _returnValueName = right._returnValueName;
    _argumentsNames  = right._argumentsNames;
    return *this;
  }
  Action&              Action::operator= ( const DString & right )
  {
    _isChecked = false;
    _command  = right;
    _parse();
    return *this;
  }  
  
  void                       Action::serialize(   DByte *& data , DULong& dataSize )
  {
    ByteArrayOutputStream     aBAO;   
    PrimitiveDataOutputStream aPDO(&aBAO);
    aPDO.writeBool(_isChecked);
    aPDO.writeString(_command);
    aPDO.writeString(_objectName);
    aPDO.writeString(_methodName);
    aPDO.writeString(_returnValueName);
    for( StringList::const_iterator iter = _argumentsNames.begin();
	 iter!= _argumentsNames.end();
	 iter++)
      {
	aPDO.writeString(*iter);
      }
    return aBAO.toByteArray(data,dataSize);
  }
  ByteArray                  Action::serialize()
  {
    ByteArrayOutputStream     aBAO;   
    PrimitiveDataOutputStream aPDO(&aBAO);
    aPDO.writeBool(_isChecked);
    aPDO.writeString(_command);
    aPDO.writeString(_objectName);
    aPDO.writeString(_methodName);
    aPDO.writeString(_returnValueName);
    for( StringList::const_iterator iter = _argumentsNames.begin();
	 iter!= _argumentsNames.end();
	 iter++)
      {
	aPDO.writeString(*iter);
      }
    return aBAO.toByteArray();
  }
  void                       Action::unSerialize( DByte * data, const DULong& dataSize )
  {    
    ByteArrayInputStream            aBAI(data,dataSize);   
    PrimitiveDataInputStream        aPDI(&aBAI);
    _isChecked       = aPDI.readBool();
    _command         = aPDI.readString();
    _objectName      = aPDI.readString();
    _methodName      = aPDI.readString();
    _returnValueName = aPDI.readString();
    _argumentsNames.clear();
    while(aBAI.available() != 0 )
      _argumentsNames.push_back( aPDI.readString());
  }
  Cloneable *                Action::clone() const 
  {
     return new Action(*this);
  }
  
  DBool  Action::equals( const Object * o ) const 
  {
    if(!findParent(_type,o)){
      return false;
    }
    return equals(*((Action*)o));
  }
  DBool  Action::equals( const Action& o ) const 
  {
    DBool aBool  =_isChecked       == o._isChecked;
    aBool       |=_command         == o._command;
    aBool       |=_objectName      == o._objectName;
    aBool       |=_methodName      == o._methodName;
    aBool       |=_returnValueName == o._returnValueName;
    aBool       |=_argumentsNames  == o._argumentsNames;
    return aBool;
  }
  
  const DString    Action::toString() const
  {
    DString aString = "isChecked  : "; 
    _isChecked ? aString+="true\n" : aString+="false\n";
    aString        += "Command    : "; 
    aString        += _command;
    aString        += "\n";
    aString        += "ObjectName : "; 
    aString        += _objectName;
    aString        += "\n";
    aString        += "RetValName : "; 
    aString        += _returnValueName;
    aString        += "\n";
    aString        += "MethodName : "; 
    aString        += _methodName;
    aString        += "\n";
    DUInt i = 0;
    for( StringList::const_iterator iter = _argumentsNames.begin();
                                    iter!= _argumentsNames.end(); 
                                    iter++){
    aString        += "Argments[";
    aString        += String::digitToString((DULong)i);
    aString        += "]   : ";
    aString        += *iter;
    aString        += "\n";
       i++; 
    }
    return aString;
  }
  Action    Action::compile( const DString& command )
      throw( PatternSyntaxException * )
  {
    return Action( command );
  }

  const DBool&       Action::isChecked() const
  {
    return _isChecked;
  }
  void               Action::execute()// const 
     throw(Exception * )
  {
    Instance& aObject      = ObjectRegistry::lookUp(_objectName); 
    if(!_returnValueName.empty()){
      if(!ObjectRegistry::has(_returnValueName)){
        Instance aReturnValue;
        aReturnValue.setObjectName(_returnValueName);
	ObjectRegistry::bind(aReturnValue);
      }
    }
    Arguments aArgs;
    for( StringList::const_iterator iter = _argumentsNames.begin();
                                    iter!= _argumentsNames.end(); 
                                    iter++)
      {
        //std::cout<<"args="<<*iter<<std::endl;
            Pattern aPattern = Pattern::compile(gStringPattern);
            Matcher aMatcher = aPattern.matcher(*iter);

            if(aMatcher.matches()){
              Instance tmpString ;
              tmpString = aMatcher.group(1);
              aArgs.push_back(tmpString);
              continue;
            }
            aPattern = Pattern::compile(gPrimitivesPattern);
            aMatcher = aPattern.matcher(*iter);
            if(aMatcher.matches()){
              DBool aCheck =true;
              DString aType       = aMatcher.group(1);
              DString aValue      = aMatcher.group(2);
              Instance aPrimitives;
              if( aType == "int"){ 
              aPrimitives = (DInt)atoll(aValue.c_str());
              }
              else if( aType == "uint"){ 
                  aPrimitives = (DUInt)atoll(aValue.c_str()); 
              }
              else if( aType == "short"){ 
                  aPrimitives = (DShort)atoll(aValue.c_str()); 
              }
              else if( aType == "ushort"){ 
                  aPrimitives = (DUShort)atoll(aValue.c_str()); 
              }
              else if( aType == "long"){ 
                  aPrimitives = (DLong)atoll(aValue.c_str()); 
              }
              else if( aType == "ulong"){ 
                  aPrimitives = (DULong)atoi(aValue.c_str()); 
              }
              else if( aType == "float"){ 
                  aPrimitives = (DFloat)atof(aValue.c_str()); 
              }
              else if( aType == "double"){ 
                  aPrimitives = (DDouble)atoi(aValue.c_str()); 
              }
              else if( aType == "char"){ 
                  aPrimitives = aValue[0];
              }
              else if( aType == "uchar"){ 
                  aPrimitives = aValue[0];
              }
              else if( aType == "byte"){ 
                  aPrimitives = aValue[0];
              }
              else if( aType == "bool"){ 
                  if(aValue == "true"){
                  aPrimitives = (DBool)true;
                  }
                  else 
                  aPrimitives = (DBool)false;
              }
              else{
                 aCheck=false; 
              }
              if(aCheck){
              aArgs.push_back(aPrimitives);
              continue;
              }
            }
          
         //std::cout<<"lookUp"<<ObjectRegistry::lookUp(*iter).get()<<std::endl;
         aArgs.push_back(ObjectRegistry::lookUp(*iter));
      }
    if(!_returnValueName.empty()){
     Instance& aReturnValue = ObjectRegistry::lookUp(_returnValueName);
     /*if(!aObject.isNull())
      aObject.get()->_lock();*/
      _lock();
     ClassLoader::execute(aObject,_methodName,aArgs,aReturnValue,_isChecked);
      _unLock();
     /*if(!aObject.isNull())
     aObject.get()->_unLock();*/
     aReturnValue.synchronizedClass();
    }
    else{
     Instance aReturnValue;
     /*if(!aObject.isNull())
     aObject.get()->_lock();*/
      _lock();
     ClassLoader::execute(aObject,_methodName,aArgs,aReturnValue,_isChecked);
      _unLock();
     /*if(!aObject.isNull())
     aObject.get()->_unLock();*/
     aReturnValue.synchronizedClass();
    }
    _isChecked=true;
  }
}
