#ifndef __DAQBuilderAction_HH__
#define __DAQBuilderAction_HH__
#include <DAQBuilderSerializableObject.hh>
#include <Exception/DAQBuilderPatternSyntaxException.hh>

namespace DAQBuilder
{
  class Action : public SerializableObject
  {
  protected:
    virtual  void              _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    Action( const DString& pattern )
      throw( PatternSyntaxException * );
    void _parse()
      throw( PatternSyntaxException * );
  public:
    Action();
    Action( const Action& right );
    virtual ~Action();
    Action&              operator= ( const Action & right );
    Action&              operator= ( const DString & right );
  public :
    virtual void                       serialize(   DByte *& ,       DULong&  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const Action& o ) const ;
  protected:
    mutable DBool              _isChecked;
    DString                    _command;
    DString                    _objectName;
    DString                    _methodName;
    DString                    _returnValueName;
    StringList                 _argumentsNames;
  public :
    const  DString    toString() const;

    static Action    compile( const DString& _pattern )
      throw( PatternSyntaxException * );
    const  DBool&      isChecked()const;
 
    void               execute() //const 
      throw( Exception *);
    const DString & getCommand() const;
  };
  inline   const DString & Action::getCommand() const
  {
     return _command;
  }
  inline void Action::_setType()
  {
    this -> _type ="Action";
  }
  inline void Action::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("SerializableObject");
  }
}
#endif
