#include <Run/DAQBuilderAction.hh>
#include <Run/DAQBuilderActionList.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderObjectOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderObjectInputStream.hh>
#include <System/DAQBuilderSystem.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  void ActionList::_finalize()
  {
    clear();
  }
  ActionList::ActionList()
    :std::vector<Action>(),SerializableObject()
  {
    _setType();
    _setParentClasses();
  }
  ActionList::ActionList( const ActionList& right)
    :std::vector<Action>(*((std::vector<Action>*)&right)),SerializableObject(*((SerializableObject*)&right))
  {
    ;
  }
  const DString ActionList::toString() const 
  {
    DString returnString;
    for( std::vector<Action>::const_iterator iter = begin();
	 iter!= end(); 
	 iter++)
      {	
	returnString+="( ";
	returnString+=  ((Action)(*iter)).getCommand();
	returnString+=" )";
	returnString += "\n";
      }
    return returnString;
  }
  ActionList::~ActionList()
  {
    _finalize();
  }
  DBool  ActionList::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
         return false;
    return equals(*((ActionList*)o));
  }
  DBool  ActionList::equals( const ActionList& o ) const 
  {
    if(size() != o.size())
      return false;
    std::vector<Action>::const_iterator iter  = begin(); 
    std::vector<Action>::const_iterator iterO = o.begin(); 
    DBool aBool=true;
    for( ; iter != end() ;iter++)
    {
      aBool |= (*iter).equals((*iterO));
    }
    return aBool;
  }
  ActionList&              ActionList::operator= ( const ActionList  & right )
  {
     *((Object*)this)           = *((Object*)&right); 
     *((std::vector<Action>*)this) = *((std::vector<Action>*)&right); 
     return *this;
   }
  void                  ActionList::serialize( DByte *& data , DULong& dataSize )
  {
    ByteArrayOutputStream aBAO;   
    ObjectOutputStream aOOS(&aBAO);
    for(  std::vector<Action>::const_iterator iter = begin();
	  iter != end();
	  iter++)
      {
	aOOS.writeObject((SerializableObject&)(*iter));
      }
    return aBAO.toByteArray(data,dataSize);
  }
  ByteArray                  ActionList::serialize()
  {
    ByteArrayOutputStream aBAO;   
    ObjectOutputStream aOOS(&aBAO);
    for(  std::vector<Action>::const_iterator iter = begin();
	  iter != end();
	  iter++)
      {
	aOOS.writeObject((SerializableObject&)(*iter));
      }
    return aBAO.toByteArray();
  }
  void                  ActionList::unSerialize( DByte * data , const DULong & dataSize )
  {
    ByteArrayInputStream     aBAI(data,dataSize);   
    ObjectInputStream        aOIS(&aBAI);
    clear();
    while(aBAI.available()!=0)
      {
        push_back(*((Action*)aOIS.readObject()));
      }
  }
  Cloneable *                ActionList::clone() const 
  { return (Cloneable*)new ActionList(*this);
  }
  void ActionList::execute()// const 
      throw( Exception  * )
  {
    for( std::vector<Action>::const_iterator iter = begin();
                                             iter!= end();
                                             iter++)
     {
         ((Action&)(*iter)).execute();
     }
  }
}
