#ifndef _DAQBuilderActionList_HH
#define _DAQBuilderActionList_HH
#include <Exception/DAQBuilderSameNameBindedException.hh>
#include <DAQBuilderSerializableObject.hh>

namespace DAQBuilder
{
  class Action;
  class ActionList : public std::vector<Action> , public SerializableObject
  {
  private :
    void              _finalize();
    void              _setType();
    void              _setParentClasses();
  public :
    virtual void                       serialize(   DByte *& ,       DULong&  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  public :
    const DString toString() const ;
    ActionList();
    ActionList( const ActionList& );
    virtual ~ActionList();
    ActionList&              operator= ( const ActionList  & right );
  public:
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const ActionList& o ) const ;
  public:
    void execute() //const 
      throw( Exception  *);
  };

  inline void              ActionList::_setType()
  {
    this -> _type="ActionList";
  }
  inline void              ActionList::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("SerializableObject");
  }
}
#endif
