#ifndef __DAQBuilderRun_HH
#define __DAQBuilderRun_HH
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <System/DAQBuilderThread.hh>
#include <Run/DAQBuilderActionList.hh>

namespace DAQBuilder
{
  class Action;
  class Run : public Thread
  {
  private:
    enum{Running,Pause,Shutdown,NumStatus };
    DInt                   _numEvents;
    ActionList             _runBeginActions;
    ActionList             _runLoopActions;
    ActionList             _runEndActions;
    DInt                   _status;
    DLong                  _eventNumber;
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public:
    Run( const DInt& _numEvents = 0 );
    Run( const Run& right );
    virtual ~Run();
    virtual Run& operator=( const Run& right );
  public:
    virtual  void              run();
  public:
    virtual  const DString toString() const ;
    DInt   getNumEvents() const;
    void   setNumEvents( const DInt&  _numEvents );

    void  addBeginAction( const Action&      beginAction );
    void  addBeginAction( const ActionList&  beginActionList );
    void  clearBeginActions() ;

    void  addLoopAction( const Action&      loopAction );
    void  addLoopAction( const ActionList&  loopActionList );
    void  clearLoopActions() ;

    void  addEndAction( const Action&      endAction );
    void  addEndAction( const ActionList&  endActionList );
    void  clearEndActions() ;

    DLong getEventNumber() const ;
  public:
    void     pause();
    void     resume();
    DBool    shutdown();
    DBool    isRunning();
  };
}
#endif
