#include <System/DAQBuilderActionRegistry.hh>
#include <Run/DAQBuilderAction.hh>

namespace DAQBuilder
{
  std::map<DString,Action>  ActionRegistry::_actionTable;

  void              ActionRegistry::unbind( const DString& key )
    throw( ActionNotFoundException * )
  {
    if((ActionRegistry::_actionTable).find(key)  
       == (ActionRegistry::_actionTable).end()){
      ActionNotFoundException * e = new ActionNotFoundException("Action not found : "+key);
      e -> insert("Location","ActionRegistry::unbind(const DString& key )");
      throw e;
	}
    (ActionRegistry::_actionTable).erase(key);
  }
  Action& ActionRegistry::lookUp( const DString& key )
    throw( ActionNotFoundException * )
  {
    std::map<DString,Action>::iterator iter 
      = (ActionRegistry::_actionTable).find(key);
    if(  iter == (ActionRegistry::_actionTable).end()){
      ActionNotFoundException * e = new ActionNotFoundException("Action not found : "+key);
      e -> insert("Location","ActionRegistry::lookUp(key)");
      throw e;
    }
    return (Action&)(iter -> second);
  }
  void              ActionRegistry::bind( const DString& name , Action& action )
    throw( SameNameBindedException * )
  {
    if((ActionRegistry::_actionTable).find(name)  
       != (ActionRegistry::_actionTable).end()){
      SameNameBindedException * e = new SameNameBindedException("Action Already Inserted : "+ name);
      e -> insert("Location","ActionRegistry::bind( const DString&  , Action&  )");
      throw e;
	}
    (ActionRegistry::_actionTable).insert(std::pair<DString,Action>(name,action));
  }
 void              ActionRegistry::rebind( const DString& name , Action& action )
   throw( ActionNotFoundException * )
  {
    std::map<DString,Action>::iterator iter 
      = (ActionRegistry::_actionTable).find(name)  ;
       if( iter  == (ActionRegistry::_actionTable).end()){
      ActionNotFoundException * e = new ActionNotFoundException("Action not found: "+name);
      e -> insert("Location","ActionRegistry::rebind( const DString& , Action&)");
      throw e;
	}
       unbind(name);
       bind(name,action);
  }
  void              ActionRegistry::clear()
  {
    (ActionRegistry::_actionTable).clear();
  }
  ActionRegistry::ActionRegistry()
    :Object()
  {
    _setType();
    _setParentClasses();
  }
  ActionRegistry::ActionRegistry( const ActionRegistry& right )
    :Object(*((Object*)&right))
  {
  }
  ActionRegistry::~ActionRegistry()
  {
    _finalize();
  }
  ActionRegistry& ActionRegistry::operator =(const ActionRegistry& right )
  {
    *((Object*)this) =       *((Object*)&right);
    return *this;
  }
  DBool   ActionRegistry::operator   ==(const ActionRegistry & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  DBool   ActionRegistry::operator   !=(const ActionRegistry & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
  const DString ActionRegistry::toString() const 
  {
    DString aString ;//= _toStringHeader();
    for( std::map< DString , Action> :: iterator iter= (ActionRegistry::_actionTable).begin() ; 
	 iter != (ActionRegistry::_actionTable).end() ; 
	 iter++)
      {
	aString            += "( ";
	aString            += iter -> first;
	aString            += " , ";
	aString            += (iter -> second).toString();
	aString            += " )\n";
      }
    //aString += _toStringFooter();
    return aString;
  }
  StringList        ActionRegistry::getBindedActionList()
      throw( ActionNotFoundException * )
  {
    StringList aStringList;
    for( std::map< DString , Action> :: iterator iter= (ActionRegistry::_actionTable).begin() ; 
	 iter != (ActionRegistry::_actionTable).end() ; 
	 iter++)
      {
	aStringList.push_back(iter -> first);
      }
    return aStringList;
  }
}
