#ifndef __DAQBuilderActionRegistry_HH__
#define __DAQBuilderActionRegistry_HH__
#include <Exception/DAQBuilderActionNotFoundException.hh>
#include <Exception/DAQBuilderSameNameBindedException.hh>

namespace DAQBuilder
{
  class Action;
  class ActionRegistry : public Object
  {
  private:
    static std::map<DString,Action>  _actionTable;
  private:
    void                     _setType();
    void                     _setParentClasses();
  public:
    const  DString           toString() const ;
  public:
    static void                bind( const DString& name , Action& object )
      throw( SameNameBindedException * );
    static void                rebind( const DString& name , Action& object )
      throw( ActionNotFoundException * );
    static void                unbind( const DString& name )
      throw( ActionNotFoundException * );
    static void                clear();
    static Action&           lookUp( const DString & name )
      throw( ActionNotFoundException * );
    static StringList        getBindedActionList()
      throw( ActionNotFoundException * );
  public :
    ActionRegistry();
    ActionRegistry( const ActionRegistry& right );
    ~ActionRegistry();
  public:    
    ActionRegistry& operator   =(const  ActionRegistry& right );
    virtual DBool   operator   ==(const ActionRegistry& right ) const ;
    virtual DBool   operator   !=(const ActionRegistry& right ) const ;
  };
  inline void   ActionRegistry::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   ActionRegistry::_setType()
  {
    this -> _type = "ActionRegistry";
  }
}
#endif
