#include <System/DAQBuilderAudioSystem.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  AudioSystem::AudioSystem( InputStream *    soundSource, 
	       const DULong&     readSize)
    :Object(),
     _soundSource(NULL), 
     _readSize(readSize)
  {
    copyAddress((Object*&)_soundSource,(Object*&)soundSource);
    _setType();
    _setParentClasses();
  }
  AudioSystem::AudioSystem( const AudioSystem& right ) 
    :Object(*((Object*)&right)),
     _soundSource(right._soundSource), 
     _readSize(right._readSize)
  {
    copyAddress((Object*&)_soundSource,(Object*&)right._soundSource);
    _setType();
    _setParentClasses();
  }
  AudioSystem::~AudioSystem()
  {
    _finalize();
  }
  AudioSystem& AudioSystem::operator   =(const AudioSystem & right )
  {
    *((Object*)this) =       *((Object*)&right);
    copyAddress((Object*&)_soundSource,(Object*&)right._soundSource);
    _readSize     =right._readSize;
    return *this;
  }
  DBool   AudioSystem::operator   ==(const AudioSystem & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    aBool      |= _soundSource     ==  right._soundSource;
    aBool      |= _readSize        ==  right._readSize;
    return aBool;
  }
  DBool   AudioSystem::operator   !=(const AudioSystem & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    aBool      |= _soundSource     !=  right._soundSource;
    aBool      |= _readSize        !=  right._readSize;
    return aBool;
  }
}
