#ifndef __DAQBuilderAudioSystem_HH__
#define __DAQBuilderAudioSystem_HH__
#include <DAQBuilderObject.hh>
#include <System/IO/DAQBuilderInputStream.hh>
#include <Exception/DAQBuilderIOException.hh>
#include <esd.h>
namespace DAQBuilder
{
  class AudioSystem : public Object 
  {
  protected:
    InputStream *     _soundSource;
    DULong            _readSize;
  protected:
    void              _setType();
    void              _setParentClasses();
  protected:
    virtual void              _open()
      throw(IOException*)=0;
  public:
    const  DString           toString() const=0 ;
  public:
    virtual void  mark()=0;
    virtual DBool markSupported()=0;
    virtual DULong play( DLong numLoop = -1 )
      throw(Exception*)=0;
    virtual void  reset()                      
      throw(IOException*)=0;
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*)=0;
    virtual void  close()
      throw(IOException*)=0;
  public :
    AudioSystem( InputStream *     _inputStream,
		 const DULong&     _readSize  = 1024 );
    AudioSystem( const AudioSystem& right );
    ~AudioSystem();
  public:    
    AudioSystem& operator   =(const AudioSystem & right );
    virtual DBool   operator   ==(const AudioSystem& right ) const ;
    virtual DBool   operator   !=(const AudioSystem& right ) const ;
  };
  inline void   AudioSystem::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   AudioSystem::_setType()
  {
    this -> _type = "AudioSystem";
  }
}
#endif
