#ifndef __DAQBuilderBits_HH__
#define __DAQBuilderBits_HH__
#include <DAQBuilderObject.hh>
#include <Exception/DAQBuilderDeflationException.hh>

namespace DAQBuilder
{
class Bits : public Object
{
protected:
  void                            _setType();
  void                            _setParentClasses();
public:
  const  DString                  toString() const;
public:
  Bits();
  Bits( const Bits& right );
  virtual ~Bits();
  
  virtual Bits&   operator   = (const Bits & right );
  virtual DBool   operator   ==(const Bits& right ) const ;
  virtual DBool   operator   !=(const Bits& right ) const ;
 public:
  static DShort  swap( DShort  x );
  static DUShort swap( DUShort x );

  static DInt    swap( DInt    x );
  static DUInt   swap( DUInt   x );

  static DLong   swap( DLong   x );
  static DULong  swap( DULong  x );
};
  inline Bits::Bits( const Bits& right )
  :Object(*((Object*)&right))
  {
  }
  inline Bits::Bits()
    :Object()
  {
  _setType();
  _setParentClasses();
  }
  inline Bits::~Bits()
  {
  }
  inline  void Bits::_setType()
  {
    _type = "Bits";
  }
  inline  void Bits::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline Bits& Bits::operator   =(const Bits & right )
  {
    *((Object*)this)    =  *((Object*)&right);
    return *this;
  }
  inline DBool   Bits::operator   ==(const Bits & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  inline DBool   Bits::operator   !=(const Bits & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
  inline DShort  Bits::swap( DShort  x )
  {
       return (DShort)((x<<8)|(x>>8)&0xff);
  }
  inline  DUShort Bits::swap( DUShort x )
  {
       return (DUShort)((x<<8)|(x>>8)&0xff);
  }

  inline  DInt    Bits::swap( DInt    x )
  {
       return (DInt)((x<<16)|(x>>16)&0xffff);
  }
  inline  DUInt   Bits::swap( DUInt   x )
  {
       return (DUInt)((x<<16)|(x>>16)&0xffff);
  }

  inline  DLong   Bits::swap( DLong   x )
  {
       return (DLong)((x<<32)|(x>>32)&0xffffffffL);
  }
  inline  DULong  Bits::swap( DULong  x )
  {
       return (DULong)((x<<32)|(x>>32)&0xffffffffL);
  }
}
#endif
