#include <dlfcn.h>
#include <System/IO/DAQBuilderFile.hh>
#include <System/DAQBuilderClassLoader.hh>
#include <System/DAQBuilderSystem.hh>
#include <Class/DAQBuilderClass.hh>
#include <Instance/DAQBuilderInstance.hh>
#include <Util/DAQBuilderMatcher.hh>
#include <Exception/DAQBuilderNullPointerException.hh>

namespace DAQBuilder
{
  static const DString gLibHead   = "libDAQBuilder";
  static const DString gLoadPath  = "/Source/Class/Classes/";
  static const DString gLibFoot   = "Instance.so";
  static const DString gGetInstance   ="getInstance";
  static const DString gExecute       ="execute";   
  ClassLoader::ClassLoader()
    :Object()
  {
    _setType();
    _setParentClasses();
  }
  ClassLoader::ClassLoader( const ClassLoader& right )
    :Object(*((Object*)&right))
  {
  }
  ClassLoader::~ClassLoader()
  {
    _finalize();
  }
  ClassLoader& ClassLoader::operator =(const ClassLoader& right )
  {
    *((Object*)this) =       *((Object*)&right);
    return *this;
  }
  DBool   ClassLoader::operator   ==(const ClassLoader & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  DBool   ClassLoader::operator   !=(const ClassLoader & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
  const DString ClassLoader::toString() const 
  {
    DString aString = "LoadPath  : ";
    aString        += System::getProperty("DAQBUILDER_ROOT");
    aString        += gLoadPath;
    aString        += "\nLibHead   : ";
    aString        += gLibHead;
    aString        += "\nLibFoot   : ";
    aString        += gLibFoot;
    return aString;
  }
  Class  ClassLoader::getClass( const DString& className  )
     throw(ClassNotFoundException * )
  { 
    Class aClass = getInstance(className).getClass();
    return aClass;
  }
  StringList        ClassLoader::getInstalledClassList() 
    throw(ClassNotFoundException* )
  {
    StringList   aReturnSL       ;
    DString aLoadPath;
    aLoadPath        += System::getProperty("DAQBUILDER_ROOT") ;
    aLoadPath        += gLoadPath;
    File aFile(aLoadPath);
    if(aFile.isExists() && aFile.isDirectory())
      {
	StringList   aStringList     = aFile.list();
	Pattern      aPattern        = Pattern::compile("libDAQBuilder\\([a-zA-Z0-9,._]+\\)Instance.so"); 
	for( StringList::const_iterator iter = aStringList.begin();
	     iter!= aStringList.end();
	     iter++) 
	  {
	    Matcher aMatcher = aPattern.matcher(*iter);
	    if(aMatcher.find())
	      {
		aReturnSL.push_back(aMatcher.group(1));
	      }
	  }
      } 
    else
      {
	ClassNotFoundException * e = 
	  new ClassNotFoundException(aLoadPath+" is not found");
	e -> insert("Location","ClassLoader::getInstalledClassList()");
	e -> insert("LoadPath",aLoadPath);
	throw e;
      }
  return aReturnSL;
  }

  Instance          ClassLoader::getInstance( const DString & key )
    throw(ClassNotFoundException* )
  { 
    //System::out.println("Check....");
    DString aLoadPath;
    aLoadPath        +=  System::getProperty("DAQBUILDER_ROOT") ;
    
    aLoadPath        += gLoadPath;
    aLoadPath        += gLibHead;
    aLoadPath        += key;
    aLoadPath        += gLibFoot;
    //System::out.println("dlopen :"+key);
    void* handle = dlopen( aLoadPath.c_str(), RTLD_LAZY | RTLD_GLOBAL );
//    void* handle = dlopen( aLoadPath.c_str(), RTLD_NOW );
    if(!handle){
      ClassNotFoundException * e = 
	new ClassNotFoundException(dlerror());
      e -> insert("Location","ClassLoader::getInstance( const DString& className  )");
      e -> insert("LoadPath",aLoadPath);
      e -> insert("dlopen","Failed");
      throw e;
    }
    
    Instance (*getInstance)() 
     = (Instance (*)())dlsym(handle,gGetInstance.c_str());
    const char * tmp= dlerror();
    if(tmp != NULL ){
      ClassNotFoundException * e = 
	new ClassNotFoundException(tmp);
      e -> insert("Location","ClassLoader::getInstance( const DString& className  )");
      e -> insert("LoadPath",aLoadPath);
      e -> insert("dlsym","Failed");
      throw e;
    }

    Instance aInstance = (*getInstance)();
    if(dlclose(handle)!=0){
      ClassNotFoundException * e = 
	new ClassNotFoundException(tmp);
      e -> insert("Location","ClassLoader::getInstance( const DString& className  )");
      e -> insert("LoadPath",aLoadPath);
      e -> insert("dlclose","Failed");
      throw e;
    }
    //System::out.println("dlclose :"+key);
    return aInstance; 
  }
void   ClassLoader::execute( Instance     & instance ,
			     const DString& methodName ,
			     Arguments&     arguments,
			     Instance&      returnValue,
			     const DBool&   isChecked )
    throw(Exception *)
  {
    //System::out.print("Check..");
    const Object *aObject = instance.get();
    
    if(methodName !="new" && aObject == NULL ){
      NullPointerException * e = 
	new NullPointerException("instance is NULL");
      e -> insert("Location","ClassLoader::execute()");
      throw e;
    }
    
    DString aLoadPath;
    aLoadPath        +=  System::getProperty("DAQBUILDER_ROOT") ;
    
    aLoadPath        += gLoadPath;
    aLoadPath        += gLibHead;
    aLoadPath        += instance.getClass().getClassName();
    aLoadPath        += gLibFoot;
    
    //System::out.println("dlopen :"+instance.getClass().getClassName());
    void* handle = dlopen( aLoadPath.c_str(), RTLD_LAZY | RTLD_GLOBAL );
 //   void* handle = dlopen( aLoadPath.c_str(), RTLD_NOW);
    if(!handle){
      ClassNotFoundException * e = 
	new ClassNotFoundException(dlerror());
      e -> insert("Location","ClassLoader::execute()");
      e -> insert("LoadPath",aLoadPath);
      e -> insert("dlopen","Failed");
      throw e;
    }
    void    (*exec)( Instance& , const DString& , Arguments & , Instance& , const DBool& )   
            = (void(*)( Instance& , const DString& , Arguments & , Instance&, const DBool& ))dlsym(handle,gExecute.c_str());
    const char * tmp= dlerror();
    if(tmp != NULL ){
      ClassNotFoundException * e = 
	new ClassNotFoundException(tmp);
      e -> insert("Location","ClassLoader::execute()");
      e -> insert("LoadPath",aLoadPath);
      e -> insert("dlsym","Failed");
      throw e;
    }
    try{
     (*exec)( instance,
	     methodName,
	     arguments,
             returnValue,
	     isChecked)   ;
    }catch(Exception * ex ){
    if(dlclose(handle)!=0){
      ClassNotFoundException * e = 
	new ClassNotFoundException(tmp);
      e -> insert("Location","ClassLoader::execute()");
      e -> insert("LoadPath",aLoadPath);
      e -> insert("dlclose","Failed");
      throw e;
    }
       throw ex;
    }
    if(dlclose(handle)!=0){
      ClassNotFoundException * e = 
	new ClassNotFoundException(tmp);
      e -> insert("Location","ClassLoader::execute()");
      e -> insert("LoadPath",aLoadPath);
      e -> insert("dlclose","Failed");
      throw e;
    }
    //System::out.println("dlclose :"+instance.getClass().getClassName());
  }
}
