#ifndef __DAQBuilderClassLoader_HH__
#define __DAQBuilderClassLoader_HH__
#include <Exception/DAQBuilderClassNotFoundException.hh>

namespace DAQBuilder
{
  class Class;
  class Instance;
  class ClassLoader : public Object 
  {
  private:
    void                     _setType();
    void                     _setParentClasses();
  public:
    const  DString           toString() const ;
  public:
    static Class             getClass( const DString & key )
      throw(ClassNotFoundException* );
    static Instance          getInstance( const DString & key )
      throw(ClassNotFoundException* );
    static void  execute( Instance     & instance ,
			 const DString& methodName ,
			 Arguments&     arguments,
			 Instance&      returnValue ,
			 const DBool&   isChecked )
      throw(Exception *);
    static StringList        getInstalledClassList()
      throw(ClassNotFoundException* );
  public :
    ClassLoader();
    ClassLoader( const ClassLoader& right );
    ~ClassLoader();
  public:    
    ClassLoader& operator   =(const ClassLoader & right );
    virtual DBool   operator   ==(const ClassLoader& right ) const ;
    virtual DBool   operator   !=(const ClassLoader& right ) const ;
  };
  inline void   ClassLoader::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   ClassLoader::_setType()
  {
    this -> _type = "ClassLoader";
  }
}
#endif
