#include <System/DAQBuilderCommandLoader.hh>
#include <Command/DAQBuilderCommand.hh>

namespace DAQBuilder
{
  std::map<DString,Command*>  CommandLoader::_commandTable;

  void              CommandLoader::deleteFromTable( const DString& key )
    throw(CommandNotFoundException*)
  {
    if((CommandLoader::_commandTable).find(key)  
       == (CommandLoader::_commandTable).end()){
      CommandNotFoundException * e = new CommandNotFoundException("CommandNotFound : "+key);
      e -> insert("Location","CommandLoader::insertToTable( Command *& object  )");
      throw e;
	}
    (CommandLoader::_commandTable).erase(key);
  }

  void              CommandLoader::insertToTable( Command * object  )
    throw(SameNameBindedException*)
  {
    if((CommandLoader::_commandTable).find(object -> getType())  
       != (CommandLoader::_commandTable).end()){
      SameNameBindedException * e = new SameNameBindedException("Object Already Inserted : "+ object->getType());
      e -> insert("Location","CommandLoader::insertToTable( Command *& object  )");
      throw e;
	}
    (CommandLoader::_commandTable).insert(std::pair<DString,Command*>(object->getType(),object));
  }
  void              CommandLoader::clearTable()
  {
    for( std::map< DString , Command *> ::iterator iter = (CommandLoader::_commandTable).begin();
	 iter                                                     != (CommandLoader::_commandTable).end();
	 iter++)
      deleteObject((Object*&)iter->second);
    (CommandLoader::_commandTable).clear();
  }
  CommandLoader::CommandLoader()
    :Object()
  {
    _setType();
    _setParentClasses();
  }
  CommandLoader::CommandLoader( const CommandLoader& right )
    :Object(*((Object*)&right))
  {
  }
  CommandLoader::CommandLoader( Command  * object )
   :Object()
  {
    _setType();
    _setParentClasses();
   CommandLoader::insertToTable(object);
  }
  CommandLoader::~CommandLoader()
  {
    _finalize();
  }
  CommandLoader& CommandLoader::operator =(const CommandLoader& right )
  {
    *((Object*)this) =       *((Object*)&right);
    return *this;
  }
  DBool   CommandLoader::operator   ==(const CommandLoader & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  DBool   CommandLoader::operator   !=(const CommandLoader & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
  const DString CommandLoader::toString() const 
  {
    DString aString ;//= _toStringHeader();
    for( std::map< DString , Command *> :: iterator iter= (CommandLoader::_commandTable).begin() ; 
	 iter != (CommandLoader::_commandTable).end() ; 
	 iter++)
      {
	aString            += "( ";
	aString            += iter -> first;
	aString            += " , ";
	aString            += iter -> second -> toString();
	aString            += " )\n";
      }
    //aString += _toStringFooter();
    return aString;
  }
 Command* CommandLoader::getCommand( const DString & key )
      throw( CommandNotFoundException * )
 {
   std::map<DString,Command*>::const_iterator iter 
     = (CommandLoader::_commandTable).find(key+"Command");
   if(  iter == (CommandLoader::_commandTable).end()){
     CommandNotFoundException * e = new CommandNotFoundException("CommandNotFound : "+key);
     e -> insert("Location","CommandLoader::getObject(key)");
     throw e;
    }
   return (Command*)(iter -> second);
 }
  void                CommandLoader::execute( const DString& commandName , const StringList& arguments )
    throw( CommandException * )
  {
    getCommand(commandName)->executeCommand(arguments);
  }
  DString             CommandLoader::getHelp( const DString& commandName )
    throw( CommandException * )
  {
    return getCommand(commandName)->getHelp();
  }
  StringList          CommandLoader::getInstalledCommandList()
      throw( CommandNotFoundException * )
  {
    StringList returnSL;
    for( std::map< DString , Command *> :: iterator iter= (CommandLoader::_commandTable).begin() ; 
	 iter != (CommandLoader::_commandTable).end() ; 
	 iter++)
      {
        DString tmp = (iter->first).substr(0,(iter->first).length()-7);
	returnSL.push_back(tmp);
      }
    return returnSL;
  }
}
