#ifndef __DAQBuilderCommandLoader_HH__
#define __DAQBuilderCommandLoader_HH__
#include <Exception/DAQBuilderCommandException.hh>
#include <Exception/DAQBuilderCommandNotFoundException.hh>
#include <Exception/DAQBuilderSameNameBindedException.hh>

namespace DAQBuilder
{
  class Command;
  class CommandLoader : public Object 
  {
  private:
    static std::map<DString,Command*>  _commandTable;
  private:
    void                     _setType();
    void                     _setParentClasses();
  public:
    const  DString           toString() const ;
  public:
    static void                deleteFromTable( const DString& key )
      throw( CommandNotFoundException * );
    static void                insertToTable( Command * object  )
      throw( SameNameBindedException * );
    static void                clearTable();
    static Command* getCommand( const DString & key )
      throw( CommandNotFoundException * );
    static void                execute( const DString& commandName , const StringList& arguments )
      throw( CommandException * );
    static DString             getHelp( const DString& commandName )
      throw( CommandException * );
    static StringList          getInstalledCommandList()
      throw( CommandNotFoundException * );
  public :
    CommandLoader();
    CommandLoader( const CommandLoader& right );
    CommandLoader( Command  * object );
    ~CommandLoader();
  public:    
    CommandLoader& operator   =(const CommandLoader & right );
    virtual DBool   operator   ==(const CommandLoader& right ) const ;
    virtual DBool   operator   !=(const CommandLoader& right ) const ;
  };
  inline void   CommandLoader::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   CommandLoader::_setType()
  {
    this -> _type = "CommandLoader";
  }
}
#endif
