#ifndef __DAQBuilderDeflater_HH__
#define __DAQBuilderDeflater_HH__
#include <DAQBuilderObject.hh>
#include <Exception/DAQBuilderDeflationException.hh>

namespace DAQBuilder
{
class Deflater : public Object
{
protected:
  void                            _setType();
  void                            _setParentClasses();
public:
  const  DString                  toString() const;
protected:
  DULong                          _bufferSize;
  DInt                            _compressionLevel;
public:
  Deflater( const DInt&    _compressionLevel = 1 ,
	    const DULong&  _bufferSize = 10240 );
  Deflater( const Deflater& right );
  virtual ~Deflater();
  
  virtual ByteArray compress(DByte* source, size_t sourceSize)
      throw( DeflationException * )=0;
  virtual Deflater& operator   = (const Deflater & right );
    virtual DBool   operator   ==(const Deflater& right ) const ;
    virtual DBool   operator   !=(const Deflater& right ) const ;

};
  inline Deflater::Deflater( const Deflater& right )
  :Object(*((Object*)&right)),
   _bufferSize(right._bufferSize),
   _compressionLevel(right._compressionLevel)
  {
  }
  inline Deflater::Deflater( const DInt& compressionLevel , const DULong& bufferSize )
    :Object(),
     _bufferSize(bufferSize),
     _compressionLevel(compressionLevel)
  {
    _setType();
    _setParentClasses();
  }
  inline Deflater::~Deflater()
  {
    _finalize();
  }
  inline  void Deflater::_setType()
  {
    _type = "Deflater";
  }
  inline  void Deflater::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline Deflater& Deflater::operator   =(const Deflater & right )
  {
    *((Object*)this)    =  *((Object*)&right);
    _compressionLevel  = right._compressionLevel;
    _bufferSize        = right._bufferSize;
    return *this;
  }
  inline DBool   Deflater::operator   ==(const Deflater & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    aBool      |= _compressionLevel== right._compressionLevel;
    aBool      |= _bufferSize      == right._bufferSize;
    return aBool;
  }
  inline DBool   Deflater::operator   !=(const Deflater & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    aBool      |= _compressionLevel!= right._compressionLevel;
    aBool      |= _bufferSize      != right._bufferSize;
    return aBool;
  }
}
#endif
