#include <System/DAQBuilderESDAudioSystem.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            ESDAudioSystem::_finalize()
  {
    close();
  }

  void              ESDAudioSystem::_open()
    throw(IOException*)
  {
    if(_soundHost.empty())
      {
      _esdFD = ::esd_open_sound(NULL);
     _soundFD = ::esd_play_stream_fallback(_soundFormat, _soundRate, NULL, _name.c_str());
      }
    else
      {
	_esdFD = ::esd_open_sound(_soundHost.c_str());
	_soundFD = ::esd_play_stream_fallback(_soundFormat, _soundRate, _soundHost.c_str(), _name.c_str());
      }
    _soundInformation  = *::esd_get_all_info(_esdFD);
  }
  const  DString                  ESDAudioSystem::toString() const 
  {
    DString aString ;//= _toStringHeader();
    return aString;
  }
  void  ESDAudioSystem::mark()
  { 
    if(markSupported())
      _soundSource -> mark();
  }                       
  DBool ESDAudioSystem::markSupported()
  {
    return _soundSource -> markSupported();
  }              
  DULong ESDAudioSystem::play( DLong numLoop  )
    throw(Exception*)
  {
    DULong totalRead = 0;
    if(numLoop <= 0 )
      numLoop = 1;
    DLong i ;
    for( i = 0 ; i < numLoop ; i++ )
    {
      mark();
    DULong numRead = 0;
    do{
      DByte * aBuf = new DByte[ _readSize ];
      numRead = _soundSource -> read( aBuf , _readSize );
      ::write( _soundFD, aBuf, numRead );
      totalRead += numRead;
      delete [] aBuf;
     }while( numRead != 0 );
      reset();
    }
    return totalRead;
  }
  void  ESDAudioSystem::reset()                      
    throw(IOException*)
  {
    _soundSource -> reset();
  }

  DLong ESDAudioSystem::skip( DLong     nSkip)       
    throw(IOException*)
  {
    return     _soundSource -> skip(nSkip);
  }

  void  ESDAudioSystem::close()
    throw(IOException*)
  {
    _soundSource -> close();
    ::esd_close(_esdFD);
    ::close(_soundFD);
  }
  ESDAudioSystem::ESDAudioSystem( InputStream *    soundSource, 
	       const DULong&     readSize,
	       const DString&    soundHost,
	       const esd_format_t& soundFormat,
	       const DInt&       soundRate,
	       const DString&    name)
    :AudioSystem(soundSource,readSize),
     _soundHost(soundHost),
     _soundFormat(soundFormat),
     _soundRate(soundRate),
     _name(name)
  {
    _setType();
    _setParentClasses();
    _open();
  }
  ESDAudioSystem::ESDAudioSystem( const ESDAudioSystem& right ) 
    :AudioSystem(*((AudioSystem*)&right)),
     _soundHost(right._soundHost),
     _soundFormat(right._soundFormat),
     _soundRate(right._soundRate),
     _name(right._name)

  {
    _setType();
    _setParentClasses();
    _open();
  }
  ESDAudioSystem::~ESDAudioSystem()
  {
    _finalize();
  }
  ESDAudioSystem& ESDAudioSystem::operator   =(const ESDAudioSystem & right )
  {
    *((AudioSystem*)this) =       *((AudioSystem*)&right);
    _soundHost    =right._soundHost;
    _soundFormat  =right._soundFormat;
    _soundRate    =right._soundRate;
    _name         =right._name;
    _open();
    return *this;
  }
}
