#ifndef __DAQBuilderESDAudioSystem_HH__
#define __DAQBuilderESDAudioSystem_HH__
#include <System/DAQBuilderAudioSystem.hh>
#include <esd.h>
namespace DAQBuilder
{
  class ESDAudioSystem : public AudioSystem
  {
  protected:
    InputStream *     _soundSource;
    DULong            _readSize;
    DString           _soundHost;
    esd_format_t      _soundFormat;
    DInt              _soundRate;
    DString           _name;
    esd_info_t        _soundInformation;
    FileDescriptor    _esdFD;
    FileDescriptor    _soundFD;
  protected:
    void              _setType();
    void              _setParentClasses();
    void              _finalize();
  protected:
    void              _open()
      throw(IOException*);
  public:
    const  DString           toString() const ;
  public:
    virtual void  mark();
    virtual DBool markSupported();
    virtual DULong play( DLong numLoop = -1 )
      throw(Exception*);
    virtual void  reset()                      
      throw(IOException*);
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*);
    virtual void  close()
      throw(IOException*);
  public :
    ESDAudioSystem( InputStream *     _inputStream,
		 const DULong&     _readSize  = 1024 ,
		 const DString&    _soundHost ="" , 
		 const esd_format_t&  _soundFormat = ESD_BITS16 | ESD_STEREO | ESD_STREAM | ESD_PLAY ,
		 const DInt&       _soundRate = ESD_DEFAULT_RATE ,
                 const DString&   _name  = "tmp.wav" );
    ESDAudioSystem( const ESDAudioSystem& right );
    ~ESDAudioSystem();
  public:    
    ESDAudioSystem& operator   =(const ESDAudioSystem & right );
  };
  inline void   ESDAudioSystem::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("AudioSystem");
  }
  inline void   ESDAudioSystem::_setType()
  {
    this -> _type = "ESDAudioSystem";
  }
}
#endif
