#include<System/DAQBuilderGZipDeflater.hh>
#include<System/IO/DAQBuilderByteArrayOutputStream.hh>
#include<System/IO/DAQBuilderByteArrayInputStream.hh>
#include<System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  void                            GZipDeflater::_finalize()
  {;}
  
  const  DString                  GZipDeflater::toString() const
  {
    DString aString ;
    aString         += "CompressionLevel :"; 
    aString         += String::digitToString((DLong)_compressionLevel);
    aString         += "\n";
    aString         += "BufferSize       :"; 
    aString         += String::digitToString((DULong)_bufferSize);
    aString         += "\n";
    return aString;
  }
  ByteArray GZipDeflater::compress(DByte* source, size_t sourceSize)
    throw( DeflationException * )
  {
    ByteArrayInputStream  aSource(source,(DULong)sourceSize);
    ByteArrayOutputStream aByteArrayOutputStream;

    DByte * aInputBuffer     = new DByte[_bufferSize];
    DByte * aOutputBuffer    = new DByte[_bufferSize];

    DInt aStatus        = Z_OK;    
    DInt aFlush         = Z_NO_FLUSH;

    _gzipStream.zalloc  = Z_NULL;
    _gzipStream.zfree   = Z_NULL;
    _gzipStream.opaque  = Z_NULL;
    
    if(deflateInit(&_gzipStream,_compressionLevel)!=Z_OK)
      {
	DeflationException * e =NULL;
	switch(aStatus)
	  {
	  case  Z_MEM_ERROR :
	    e = new DeflationException("Not enough memory ");
	    break;
	  case  Z_BUF_ERROR:
	    e = new DeflationException("Not enough buffer ");
	    break;
	  case  Z_STREAM_ERROR:
	    e = new DeflationException("Illegal compression Level ");
	    break;
	    default :
	      e = new DeflationException("UnKnown Error  ");
	    break;
	  }
	delete [] aInputBuffer;
	delete [] aOutputBuffer;
	throw e;
      }
    _gzipStream.avail_in = 0;
    _gzipStream.next_out = aOutputBuffer;
    _gzipStream.avail_out= _bufferSize;


    while(true)
      {
        if(_gzipStream.avail_in == 0 ){
	  _gzipStream.next_in   = aInputBuffer;
	  _gzipStream.avail_in  = aSource.read(aInputBuffer,_bufferSize);
	  if(aSource.isEOF())
	    aFlush = Z_FINISH;
	}
	
	aStatus = deflate(&_gzipStream,aFlush);

	if( aStatus == Z_STREAM_END)break;
        if( aStatus != Z_OK )
	  {
            DeflationException * e =NULL;
            switch(aStatus)
	      {
	      case  Z_MEM_ERROR :
		e = new DeflationException("Not enough memory ");
		break;
	      case  Z_BUF_ERROR:
		e = new DeflationException("Not enough buffer ");
		break;
	      case  Z_STREAM_ERROR:
		e = new DeflationException("Illegal compression Level ");
		break;
              default :
	        e = new DeflationException("UnKnown Error  ");
	        break;
	      }
	    delete [] aInputBuffer;
	    delete [] aOutputBuffer;
            throw e;
	  }
        if( _gzipStream.avail_out == 0 ){
           aByteArrayOutputStream.write(aOutputBuffer,_bufferSize);
          _gzipStream.next_out = aOutputBuffer;
          _gzipStream.avail_out= _bufferSize;
	}
      }

    DULong  aCount ;
    if(( aCount = _bufferSize - _gzipStream.avail_out)!=0){
        aByteArrayOutputStream.write(aOutputBuffer,aCount);
    }
    delete [] aInputBuffer;
    delete [] aOutputBuffer;
    if( deflateEnd(&_gzipStream) != Z_OK )
	  {
            DeflationException * e =NULL;
            switch(aStatus)
	      {
	      case  Z_MEM_ERROR :
		e = new DeflationException("Not enough memory ");
		break;
	      case  Z_BUF_ERROR:
		e = new DeflationException("Not enough buffer ");
		break;
	      case  Z_STREAM_ERROR:
		e = new DeflationException("Illegal compression Level ");
		break;
		default :
		  e = new DeflationException("UnKnown Error  ");
	        break;
	      }
	    delete [] aInputBuffer;
	    delete [] aOutputBuffer;
            throw e;
	  }
    return aByteArrayOutputStream.toByteArray();
  }
  DBool   GZipDeflater::operator   ==(const GZipDeflater & right ) const 
  {
    DBool aBool = *((Deflater*)this) ==  *((Deflater*)&right);
    aBool      |= memcmp(&_gzipStream,&right._gzipStream,sizeof(_gzipStream))==0;
    return aBool;
  }
  DBool   GZipDeflater::operator   !=(const GZipDeflater & right ) const 
  {
    DBool aBool = *((Deflater*)this) !=  *((Deflater*)&right);
    aBool      |= memcmp(&_gzipStream,&right._gzipStream,sizeof(_gzipStream))!=0;
    return aBool;
  }
}
