#ifndef __DAQBuilderGZipDeflater_HH__
#define __DAQBuilderGZipDeflater_HH__
#include <System/DAQBuilderDeflater.hh>
#include <zlib.h>

namespace DAQBuilder
{
class GZipDeflater : public Deflater
{
protected:
  void                            _setType();
  void                            _setParentClasses();
  void                            _finalize();
public:
  const  DString                  toString() const;
protected:
  z_stream                        _gzipStream;
public:
  GZipDeflater( const DInt&    _compressionLevel = Z_BEST_COMPRESSION ,
		const DULong&  _bufferSize = 10240 );
  GZipDeflater( const GZipDeflater& right );
  virtual ~GZipDeflater();
  
  virtual ByteArray compress(DByte* source , size_t sourceSize)
      throw( DeflationException * );
  virtual GZipDeflater& operator   =(const GZipDeflater & right );
    virtual DBool   operator   ==(const GZipDeflater& right ) const ;
    virtual DBool   operator   !=(const GZipDeflater& right ) const ;

};
  inline GZipDeflater::GZipDeflater( const GZipDeflater& right )
  :Deflater(*((Deflater*)&right)),_gzipStream(right._gzipStream)
  {
  _setType();
  _setParentClasses();
  }
  inline GZipDeflater::GZipDeflater( const DInt&     compressionLevel ,
				     const DULong &  bufferSize )
    :Deflater( compressionLevel , bufferSize )
  {
    bzero(&_gzipStream,sizeof(z_stream));
    _setType();
    _setParentClasses();
  }
  inline GZipDeflater::~GZipDeflater()
  {
    _finalize();
  }
  inline  void GZipDeflater::_setType()
  {
    _type = "GZipDeflater";
  }
  inline  void GZipDeflater::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Deflater");
  }
  inline GZipDeflater& GZipDeflater::operator   =(const GZipDeflater & right )
  {
    *((Deflater*)this)    =  *((Deflater*)&right);
    _gzipStream           =  right._gzipStream;
    return *this;
  }
}
#endif
