#include<System/DAQBuilderGZipInflater.hh>
#include<System/IO/DAQBuilderByteArrayInputStream.hh>
#include<System/IO/DAQBuilderByteArrayOutputStream.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  void                            GZipInflater::_finalize()
  {;}
  
  const  DString                  GZipInflater::toString() const
  {
    DString aString ;
    return aString;
  }
  ByteArray GZipInflater::unCompress(DByte* source, size_t   sourceSize ,
				     DByte* inflate , size_t inflateSize )
    throw( InflationException * )
  {
    ByteArrayOutputStream       aByteArrayOutputStream;
    int aStatus = ::uncompress( (Bytef*)inflate , (uLongf*)&inflateSize,
				(Bytef*)source ,  sourceSize );
    
    if( aStatus != Z_OK )
      {
	InflationException * e =NULL;
	switch(aStatus)
	  {
	  case  Z_MEM_ERROR :
	    e = new InflationException("Not enough memory ");
	    break;
	  case  Z_BUF_ERROR:
	    e = new InflationException("Not enough buffer ");
	    break;
	  case  Z_DATA_ERROR:
	    e = new InflationException("Source data is broken");
	    break;
	  default :
	    e = new InflationException("UnKnown Error  ");
	    break;
	  }
	throw e;
      }
    aByteArrayOutputStream.write(inflate,inflateSize);
    return aByteArrayOutputStream.toByteArray();
  }
  ByteArray GZipInflater::unCompress(DByte* source, size_t sourceSize)
    throw( InflationException * )
  {
    ByteArrayInputStream  aSource(source,(DULong)sourceSize);
    ByteArrayOutputStream aByteArrayOutputStream;
    
    DByte * aInputBuffer     = new DByte[_bufferSize];
    DByte * aOutputBuffer    = new DByte[_bufferSize];
    
    _gzipStream.zalloc  = Z_NULL;
    _gzipStream.zfree   = Z_NULL;
    _gzipStream.opaque  = Z_NULL;
    
    _gzipStream.next_in  = Z_NULL;
    _gzipStream.avail_in = 0;
    
    DInt aStatus = Z_OK;
    if((aStatus = inflateInit(&_gzipStream))!=Z_OK)
      {
	InflationException * e = _gzipStream.msg ? 
	  new InflationException(_gzipStream.msg) : NULL;
	if(e==NULL){
	  switch(aStatus)
	    {
	    case  Z_MEM_ERROR :
	      e = new InflationException("Not enough memory ");
	      break;
	    case  Z_BUF_ERROR:
	      e = new InflationException("Not enough buffer ");
	      break;
	    case  Z_DATA_ERROR:
	      e = new InflationException("Source data is broken");
	      break;
	    default :
	      e = new InflationException("UnKnown Error  ");
	      break;
	    }
	}
	delete [] aInputBuffer;
	delete [] aOutputBuffer;
	throw e;
      }
    _gzipStream.next_out = (Bytef*)aOutputBuffer;
    _gzipStream.avail_out= (uInt)_bufferSize;
    
    while(aStatus != Z_STREAM_END)
      {
        if(_gzipStream.avail_in == 0 ){
	  _gzipStream.next_in   = aInputBuffer;
	  _gzipStream.avail_in  = (uInt)aSource.read(aInputBuffer,_bufferSize);
	}
	
	aStatus = inflate(&_gzipStream,Z_NO_FLUSH);

	if( aStatus == Z_STREAM_END)break;
        if( aStatus != Z_OK )
	  {
	    InflationException * e = _gzipStream.msg ? 
	      new InflationException(_gzipStream.msg) : NULL;
	    if(e==NULL){
	      switch(aStatus)
		{
		case  Z_MEM_ERROR :
		  e = new InflationException("Not enough memory ");
		  break;
		case  Z_BUF_ERROR:
		  e = new InflationException("Not enough buffer ");
		  break;
		case  Z_DATA_ERROR:
		  e = new InflationException("Source data is broken");
		  break;
		default :
		  e = new InflationException("UnKnown Error  ");
		  break;
		}
	    }
	    delete [] aInputBuffer;
	    delete [] aOutputBuffer;
	    throw e;
	  }
        if( _gzipStream.avail_out == 0 ){
	  aByteArrayOutputStream.write(aOutputBuffer,_bufferSize);
          _gzipStream.next_out = (Bytef*)aOutputBuffer;
          _gzipStream.avail_out= (uInt)_bufferSize;
	}
      }
    
    DULong  aCount ;
    if(( aCount = _bufferSize - _gzipStream.avail_out)!=0){
      aByteArrayOutputStream.write(aOutputBuffer,aCount);
    }
    delete [] aInputBuffer;
    delete [] aOutputBuffer;
    if( inflateEnd(&_gzipStream) != Z_OK )
      {
	InflationException * e = _gzipStream.msg ? 
	  new InflationException(_gzipStream.msg) : NULL;
	if(e==NULL){
	  switch(aStatus)
	    {
	    case  Z_MEM_ERROR :
	      e = new InflationException("Not enough memory ");
	      break;
	    case  Z_BUF_ERROR:
	      e = new InflationException("Not enough buffer ");
	      break;
	    case  Z_DATA_ERROR:
	      e = new InflationException("Source data is broken");
	      break;
	    default :
	      e = new InflationException("UnKnown Error  ");
	      break;
	    }
	}
	delete [] aInputBuffer;
	delete [] aOutputBuffer;
	throw e;
      }
    return aByteArrayOutputStream.toByteArray();
  }
  DBool   GZipInflater::operator   ==(const GZipInflater & right ) const 
  {
    DBool aBool = *((Inflater*)this) ==  *((Inflater*)&right);
    aBool      |= memcmp(&_gzipStream,&right._gzipStream,sizeof(_gzipStream))==0;
    return aBool;
  }
  DBool   GZipInflater::operator   !=(const GZipInflater & right ) const 
  {
    DBool aBool = *((Inflater*)this) !=  *((Inflater*)&right);
    aBool      |= memcmp(&_gzipStream,&right._gzipStream,sizeof(_gzipStream))!=0;
    return aBool;
  }
}
