#ifndef __DAQBuilderGZipInflater_HH__
#define __DAQBuilderGZipInflater_HH__
#include <System/DAQBuilderInflater.hh>
#include <zlib.h>

namespace DAQBuilder
{
class GZipInflater : public Inflater
{
protected:
  void                            _setType();
  void                            _setParentClasses();
  void                            _finalize();
public:
  const  DString                  toString() const;
protected:
  z_stream                        _gzipStream;
public:
  virtual ByteArray unCompress(DByte* source , size_t sourceSize)
      throw( InflationException * );
  virtual ByteArray unCompress(DByte* source, size_t sourceSize ,
			       DByte* inflate , size_t aInflateSize )
    throw( InflationException * );
public:
  GZipInflater( const DULong& _bufferSize = 10240);
  GZipInflater( const GZipInflater& right );
  virtual ~GZipInflater();
  virtual GZipInflater& operator   =(const GZipInflater & right );
  virtual DBool   operator   ==(const GZipInflater & right ) const ;
  virtual DBool   operator   !=(const GZipInflater & right ) const ;

};
  inline GZipInflater::GZipInflater( const GZipInflater& right )
    :Inflater(*((Inflater*)&right)),_gzipStream(right._gzipStream)
  {
  }
  inline GZipInflater::GZipInflater( const DULong & bufferSize)
    :Inflater(bufferSize)
  {
    bzero(&_gzipStream,sizeof(z_stream));
    _setType();
    _setParentClasses();
  }
  inline GZipInflater::~GZipInflater()
  {
    _finalize();
  }
  inline  void GZipInflater::_setType()
  {
    _type = "GZipInflater";
  }
  inline  void GZipInflater::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Inflater");
  }
  inline GZipInflater& GZipInflater::operator   =(const GZipInflater & right )
  {
    *((Inflater*)this)    =  *((Inflater*)&right);
    _gzipStream           =  right._gzipStream;
    return *this;
  }
}
#endif
