#ifndef __DAQBuilderInflater_HH__
#define __DAQBuilderInflater_HH__
#include <DAQBuilderObject.hh>
#include <Exception/DAQBuilderInflationException.hh>

namespace DAQBuilder
{
class Inflater : public Object
{
protected:
  void                            _setType();
  void                            _setParentClasses();
public:
  const  DString                  toString() const ;
protected:
  DULong                          _bufferSize;
public:
  Inflater( const DULong& _bufferSize );
  Inflater( const Inflater& right );
  virtual ~Inflater();
  
  virtual ByteArray unCompress(DByte* source, size_t sourceSize)
      throw( InflationException * )=0;
  virtual ByteArray unCompress(DByte* source, size_t sourceSize ,
			       DByte* inflate , size_t aInflateSize )
    throw( InflationException * )=0;
  virtual Inflater& operator   =(const Inflater & right );
    virtual DBool   operator   ==(const Inflater& right ) const ;
    virtual DBool   operator   !=(const Inflater& right ) const ;

};
  inline Inflater::Inflater( const Inflater& right )
  :Object(*((Object*)&right)),_bufferSize(right._bufferSize)
  {
  }
  inline Inflater::Inflater( const DULong& bufferSize)
    :Object(),_bufferSize(bufferSize)
  {
    _setType();
    _setParentClasses();
  }
  inline Inflater::~Inflater()
  {
    _finalize();
  }
  inline  void Inflater::_setType()
  {
    _type = "Inflater";
  }
  inline  void Inflater::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline Inflater& Inflater::operator   =(const Inflater & right )
  {
    *((Object*)this)    =  *((Object*)&right);
    _bufferSize         = _bufferSize;
    return *this;
  }
  inline DBool   Inflater::operator   ==(const Inflater & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    aBool      |= _bufferSize      == right._bufferSize;
    return aBool;
  }
  inline DBool   Inflater::operator   !=(const Inflater & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    aBool      |= _bufferSize      != right._bufferSize;
    return aBool;
  }
}
#endif
