#include <System/DAQBuilderObjectRegistry.hh>

namespace DAQBuilder
{
  std::map<DString,Instance>  ObjectRegistry::_objectTable;

  void              ObjectRegistry::unbind( const DString& key )
    throw( ObjectNotFoundException * )
  {
    if((ObjectRegistry::_objectTable).find(key)  
       == (ObjectRegistry::_objectTable).end()){
      ObjectNotFoundException * e = new ObjectNotFoundException("Object not found : "+key);
      e -> insert("Location","ObjectRegistry::unbind(const DString& key )");
      throw e;
	}
    (ObjectRegistry::_objectTable).erase(key);
  }
  Instance& ObjectRegistry::lookUp( const DString& key )
    throw( ObjectNotFoundException * )
  {
    std::map<DString,Instance>::iterator iter 
      = (ObjectRegistry::_objectTable).find(key);
    if(  iter == (ObjectRegistry::_objectTable).end()){
      ObjectNotFoundException * e = new ObjectNotFoundException("Object not found : "+key);
      e -> insert("Location","ObjectRegistry::lookUp(key)");
      throw e;
    }
    return (Instance&)(iter -> second);
  }
  void              ObjectRegistry::bind( Instance& object )
    throw( SameNameBindedException * )
  {
    if((ObjectRegistry::_objectTable).find(object.getObjectName())  
       != (ObjectRegistry::_objectTable).end()){
      SameNameBindedException * e = new SameNameBindedException("Object Already Inserted : "+ object.getObjectName());
      e -> insert("Location","ObjectRegistry::bind( const DString&  , Instance&  )");
      throw e;
	}
    (ObjectRegistry::_objectTable).insert(std::pair<DString,Instance>(object.getObjectName(),object));
  }
 void              ObjectRegistry::rebind( Instance& object )
   throw( ObjectNotFoundException * )
  {
    std::map<DString,Instance>::iterator iter 
      = (ObjectRegistry::_objectTable).find(object.getObjectName())  ;
       if( iter  == (ObjectRegistry::_objectTable).end()){
      ObjectNotFoundException * e = new ObjectNotFoundException("Object not found: "+object.getObjectName());
      e -> insert("Location","ObjectRegistry::rebind( const DString& , Instance&)");
      throw e;
	}
       unbind(object.getObjectName());
       bind(object);
  }
  void              ObjectRegistry::clear()
  {
    (ObjectRegistry::_objectTable).clear();
  }
  ObjectRegistry::ObjectRegistry()
    :Object()
  {
    _setType();
    _setParentClasses();
  }
  ObjectRegistry::ObjectRegistry( const ObjectRegistry& right )
    :Object(*((Object*)&right))
  {
  }
  ObjectRegistry::~ObjectRegistry()
  {
    _finalize();
  }
  ObjectRegistry& ObjectRegistry::operator =(const ObjectRegistry& right )
  {
    *((Object*)this) =       *((Object*)&right);
    return *this;
  }
  DBool   ObjectRegistry::operator   ==(const ObjectRegistry & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  DBool   ObjectRegistry::operator   !=(const ObjectRegistry & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
  const DString ObjectRegistry::toString() const 
  {
    DString aString ;//= _toStringHeader();
    for( std::map< DString , Instance> :: iterator iter= (ObjectRegistry::_objectTable).begin() ; 
	 iter != (ObjectRegistry::_objectTable).end() ; 
	 iter++)
      {
	aString            += "( ";
	aString            += iter -> first;
	aString            += " , ";
	aString            += (iter -> second).isNull() ? "NULL" : (iter->second)-> getType();// (iter->second)-> toString();
	aString            += " )\n";
      }
    //aString += _toStringFooter();
    return aString;
  }
  StringList        ObjectRegistry::getBindedObjectList()
      throw( ObjectNotFoundException * )
  {
    StringList aStringList;
    for( std::map< DString , Instance> :: iterator iter= (ObjectRegistry::_objectTable).begin() ; 
	 iter != (ObjectRegistry::_objectTable).end() ; 
	 iter++)
      {
	aStringList.push_back(iter -> first);
      }
    return aStringList;
  }
}
