#ifndef __DAQBuilderObjectRegistry_HH__
#define __DAQBuilderObjectRegistry_HH__
#include <Instance/DAQBuilderInstance.hh>
#include <Exception/DAQBuilderObjectNotFoundException.hh>
#include <Exception/DAQBuilderSameNameBindedException.hh>

namespace DAQBuilder
{
  class Instance;
  class ObjectRegistry : public Object 
  {
  private:
    static std::map<DString,Instance>  _objectTable;
  private:
    void                     _setType();
    void                     _setParentClasses();
  public:
    const  DString           toString() const ;
  public:
    static void                bind( Instance& object )
      throw( SameNameBindedException * );
    static void                rebind( Instance& object )
      throw( ObjectNotFoundException * );
    static void                unbind( const DString& name )
      throw( ObjectNotFoundException * );
    static void                clear();
    static Instance&           lookUp( const DString & name )
      throw( ObjectNotFoundException * );
    static StringList          getBindedObjectList()
      throw( ObjectNotFoundException * );
    static DBool               has( const DString & name );
  public :
    ObjectRegistry();
    ObjectRegistry( const ObjectRegistry& right );
    ~ObjectRegistry();
  public:    
    ObjectRegistry& operator   =(const ObjectRegistry & right );
    virtual DBool   operator   ==(const ObjectRegistry& right ) const ;
    virtual DBool   operator   !=(const ObjectRegistry& right ) const ;
  };
  inline void   ObjectRegistry::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   ObjectRegistry::_setType()
  {
    this -> _type = "ObjectRegistry";
  }
  inline DBool  ObjectRegistry::has( const DString& name )
  {
    std::map<DString,Instance>::iterator iter 
      = (ObjectRegistry::_objectTable).find(name);
    
    return  iter != (ObjectRegistry::_objectTable).end();
  }
}
#endif
